#include "iteration_functions.h"

double round_to_digits(double value, int digits)
{
  if (value == 0.0) // otherwise it will return 'nan' due to the log10() of zero
    return 0.0;

  double factor = pow(10.0, digits - ceil(log10(fabs(value))));
  return round(value * factor) / factor;
}
