#include <local_header.h>
#include "common_header.h"
#include "functions.h"
#include "globals.h"
#include "hydrodynamics.h"
#include "variables.h"

void simul_sync()
{
	
	int ii;
	double energy=0;
	double csi=0;
	
	kerr_data* ptr_data;
	ptr_data = (kerr_data*)malloc(sizeof(kerr_data));
	
	stokes_parameters ptr_stokes[POLAR_NBOUNDS - 1];
	stokes_parameters ptr_stokes_average[POLAR_NBOUNDS - 1];
	
	/*============================================================================*/
	
	 matrix_gb =
	      stringconcat(getenv("MC_INSTDIR"), "/electron_distributions/maxwellian/gammabeta_lab.fits");
	  array_gb = read_matrix(matrix_gb);

	  ptr_data->array_gb = array_gb;
	  if (array_gb == NULL)
	  {
	    printf("\nError in assigning pointer memory to pointer array_gb\n");
	    printf("Line %d of file %s\n", __LINE__, __FILE__);
	    exit(1);
	  }

	 ptr_gb = read_array(
	      stringconcat(getenv("MC_INSTDIR"), "/electron_distributions/maxwellian/temp_random.txt"));
	  ptr_data->ptr_gb = ptr_gb;
	  
	  if (ptr_gb == NULL)
	  {
	    printf("\nError in assigning pointer memory to pointer ptr_gb\n");
	    printf("Line %d of file %s\n", __LINE__, __FILE__);
	    exit(1);
	  }
	  
	  /*============================================================================*/

	// init_globals(ptr_data, ptr_stokes, ptr_stokes_average);
	  
	 double r0=10;
	 double theta0=PI/2;
	 double phi=0;
	 double source_fact=1;
	 double ph_ene=0;
	 
	 sync_seedphotons(ptr_data, r0, &theta0, &phi0, &source_fact, &ph_ene);
	
	
	        for (ii=0; ii< 300; ii++)
	        {
	                //metropolis_gibbs_sampling(&energy, &csi, 50);
	                //printf("%lf %lf  %5.4e\n", energy, csi, Psync_total(energy, csi));
	                
	                //printf("%lf  %lf\n", ParalleSyncMode, PerpendicularSyncMode);
	                sync_seedphotons(ptr_data, r0, &theta0, &phi0, &source_fact, &ph_ene);
	                
	        }

	
	
}

