#include "iteration_functions.h"

double sum_kiter(int k_min, int k_max, int jj, Iklr_intensity* ptr_Iklr, Ikl_intensity* ptr_Ikl, Ikr_intensity* ptr_Ikr, int method);

void compute_results(int method,
                     int k_iter,
                     int Nstep_tau,
                     int Nstep_mu,
                     double* array_mu,
                     double* weights_u,
                     Iklr_intensity* ptr_Iklr,
                     Ikl_intensity* ptr_Ikl,
                     Ikr_intensity* ptr_Ikr)
{
  int jj, kk;
  double* Pdeg = malloc(Nstep_mu * sizeof(double));

  double* Pdeg_Band1 = malloc(Nstep_mu * sizeof(double));
  double* Pdeg_Band2 = malloc(Nstep_mu * sizeof(double));
  double* Pdeg_Band3 = malloc(Nstep_mu * sizeof(double));
  double* Pdeg_Band4 = malloc(Nstep_mu * sizeof(double));
  double* Pdeg_Band5 = malloc(Nstep_mu * sizeof(double));

  double* Itot_upstream = malloc(Nstep_mu * sizeof(double));
  double* Itot_downstream = malloc(Nstep_mu * sizeof(double));

  double sum_Il, sum_Ir;

  double sum_Il_downstream, sum_Ir_downstream;

  FILE* dat;

  dat = fopen(polarization_file, "w");

  for (jj = 0; jj < Nstep_mu; jj++)
  {
    sum_Il = 0;
    sum_Ir = 0;
    sum_Il_downstream = 0;
    sum_Ir_downstream = 0;

    for (kk = 0; kk < k_iter; kk++)
    {
      if (method == 1)
      {
        sum_Il = sum_Il + ptr_Iklr[kk].Il_matrix_upstream[Nstep_tau - 1][jj];
        sum_Ir = sum_Ir + ptr_Iklr[kk].Ir_matrix_upstream[Nstep_tau - 1][jj];

        sum_Il_downstream = sum_Il_downstream + ptr_Iklr[kk].Il_matrix_downstream[Nstep_tau - 1][jj];
        sum_Ir_downstream = sum_Ir_downstream + ptr_Iklr[kk].Ir_matrix_downstream[Nstep_tau - 1][jj];
      }
      else
      {
        sum_Il = sum_Il + ptr_Ikl[kk].matrix[0][jj];
        sum_Ir = sum_Ir + ptr_Ikr[kk].matrix[0][jj];
      }
    }

    if (disktau >= 4 && k_iter > 40)
    {
      Pdeg_Band1[jj] = sum_kiter(0, 10, jj, ptr_Iklr, ptr_Ikl, ptr_Ikr, method);
      Pdeg_Band2[jj] = sum_kiter(10, 20, jj, ptr_Iklr, ptr_Ikl, ptr_Ikr, method);
      Pdeg_Band3[jj] = sum_kiter(20, 30, jj, ptr_Iklr, ptr_Ikl, ptr_Ikr, method);
      Pdeg_Band4[jj] = sum_kiter(30, 40, jj, ptr_Iklr, ptr_Ikl, ptr_Ikr, method);
      Pdeg_Band5[jj] = sum_kiter(40, k_iter, jj, ptr_Iklr, ptr_Ikl, ptr_Ikr, method);
    }

    Pdeg[jj] = (sum_Ir - sum_Il) / (sum_Ir + sum_Il);

    if (isnan(Pdeg[jj]))
    {
      printf("Error: Pdeg is NaN at u=%lf  sum_Ir=%4.3e sum_Il=%4.3e\n", array_mu[jj], sum_Ir, sum_Il);
    }

    Itot_upstream[jj] = (sum_Ir + sum_Il);
    Itot_downstream[jj] = sum_Ir_downstream + sum_Il_downstream;
  }

  /*===========================================================================*/
  /*Print I(u) normalized at the value u=1*/
  /*===========================================================================*/

  fprintf(dat, "!Col1: cos(theta)\n");
  fprintf(dat, "!Col2: Pdeg\n");
  fprintf(dat, "!Col3: I(u)/I(u=1)\n");
  
  
  if (disktau < 4)
  {	  
    for (jj = 0; jj < Nstep_mu; jj++)
    {
      fprintf(dat, "%lf  %5.4e  %5.4e\n", array_mu[jj], Pdeg[jj],
              Itot_upstream[jj] / Itot_upstream[Nstep_mu - 1]);
    }
  }
  else
	  
	  fprintf(dat, "!Pdeg band 1\n");
	    fprintf(dat, "!Pdeg band 2\n");
	    fprintf(dat, "!Pdeg band 3\n");
	    fprintf(dat, "!Pdeg band 4\n");
	      fprintf(dat, "!Pdeg band 5\n");
	      
	     
	   
	  
  {
    for (jj = 0; jj < Nstep_mu; jj++)
    {
      fprintf(dat, "%lf  %5.4e  %5.4e %5.4e  %5.4e  %5.4e  %5.4e  %5.4e \n", array_mu[jj], Pdeg[jj],
              Itot_upstream[jj] / Itot_upstream[Nstep_mu - 1], Pdeg_Band1[jj], Pdeg_Band2[jj],
              Pdeg_Band3[jj], Pdeg_Band4[jj], Pdeg_Band5[jj]);
    }
  }

  fclose(dat);

  /*===========================================================================*/

  double TotalFlux = 0;
  double TotalFlux_downstream = 0;

  for (jj = 0; jj < Nstep_mu; jj++)
  {
    TotalFlux = TotalFlux + Itot_upstream[jj] * array_mu[jj] * weights_u[jj];

    TotalFlux_downstream = TotalFlux_downstream + Itot_downstream[jj] * array_mu[jj] * weights_u[jj];
  }

  printf("Total flux at the top    (u>0)  %lf\n", TotalFlux);
  printf("Total flux at the bottom (u<0)  %lf\n", TotalFlux_downstream);
  printf("Percenatge of flux at the top %5.4f\n", TotalFlux / (TotalFlux + TotalFlux_downstream));

  /*===========================================================================*/

  dat = fopen(diffusion_file, "w");
  fprintf(dat, "!Total flux at the top    (u>0)  %lf\n", TotalFlux);
  fprintf(dat, "!Total flux at the bottom (u<0)  %lf\n", TotalFlux_downstream);
  fprintf(dat, "!Percenatge of flux at the top %5.4f\n", TotalFlux / (TotalFlux + TotalFlux_downstream));

  double* diffusion = malloc(k_iter * sizeof(double));
  double sum_k;
  double Fval_max = -10;

  for (kk = 0; kk < k_iter; kk++)
  {
    sum_k = 0;

    for (jj = 0; jj < Nstep_mu; jj++)
    {
      if (method == 1)
      {
        sum_k = sum_k + ptr_Iklr[kk].Il_matrix_upstream[Nstep_tau - 1][jj] * weights_u[jj] * array_mu[jj] +
                ptr_Iklr[kk].Ir_matrix_upstream[Nstep_tau - 1][jj] * weights_u[jj] * array_mu[jj];
      }
      else
      {
        sum_k = sum_k + ptr_Ikl[kk].matrix[0][jj] + ptr_Ikr[kk].matrix[0][jj];
      }
    }

    diffusion[kk] = sum_k;

    if (diffusion[kk] > Fval_max)
      Fval_max = diffusion[kk];
  }

  for (kk = 0; kk < k_iter; kk++)
  {
    fprintf(dat, "%d  %5.4f\n", kk, diffusion[kk] / Fval_max);
  }

  fclose(dat);

  /*===================================================================================*/

  radiation_field_t* radiation_field = (radiation_field_t*)malloc(sizeof(radiation_field_t));
  radiation_field->u_min = array_mu[0];
  radiation_field->u_max = array_mu[Nstep_mu - 1];

  read_resultsfile(polarization_file, radiation_field, RTE);

  setup_gsl_objects(radiation_field, RTE);

  check_results(Spline_sample_Iu, Spline_eval_pdeg, Spline_eval_limbdark);
}

/*========================================================================*/

double sum_kiter(int k_min, int k_max, int jj, Iklr_intensity* ptr_Iklr, Ikl_intensity* ptr_Ikl, Ikr_intensity* ptr_Ikr, int method)
{
  int kk;
  double Pdeg;
  double sum_Il;
  double sum_Ir;
  double sum_Il_downstream;
  double sum_Ir_downstream;

  sum_Il = 0;
  sum_Ir = 0;
  sum_Il_downstream = 0;
  sum_Ir_downstream = 0;

  for (kk = k_min; kk < k_max; kk++)
  {
    if (method == 1)
    {
      sum_Il = sum_Il + ptr_Iklr[kk].Il_matrix_upstream[Nstep_tau - 1][jj];
      sum_Ir = sum_Ir + ptr_Iklr[kk].Ir_matrix_upstream[Nstep_tau - 1][jj];

      sum_Il_downstream = sum_Il_downstream + ptr_Iklr[kk].Il_matrix_downstream[Nstep_tau - 1][jj];
      sum_Ir_downstream = sum_Ir_downstream + ptr_Iklr[kk].Ir_matrix_downstream[Nstep_tau - 1][jj];
    }
    else
    {
      sum_Il = sum_Il + ptr_Ikl[kk].matrix[0][jj];
      sum_Ir = sum_Ir + ptr_Ikr[kk].matrix[0][jj];
    }
  }

  Pdeg = (sum_Ir - sum_Il) / (sum_Ir + sum_Il);

  return Pdeg;
}
