#include "iteration_functions.h"

void check_results(gsl_spline* Spline_sample_Iu, gsl_spline* Spline_eval_pdeg, gsl_spline* Spline_eval_limbdark)
{
  double u_test = 0, P = 0, Itot = 0;
  /*double Ir, Il;*/
  double csi;
  int ii, status;

  for (ii = 0; ii < 2500; ii++)
  {
    csi = clock_random();
    status = gsl_spline_eval_e(Spline_sample_Iu, csi, xacc_1d, &u_test);

    if (status)
    {
      printf("File %s\n", __FILE__);
      printf("csi=%lf \n", csi);
      printf("Error at line %d: %s\n", __LINE__, gsl_strerror(status));
      exit(1);
    }

    status = gsl_spline_eval_e(Spline_eval_pdeg, u_test, xacc_1d, &P);
    if (status)
    {
      printf("File %s\n", __FILE__);
      printf("csi=%lf u_test=%lf\n", csi, u_test);
      printf("Error at line %d: %s\n", __LINE__, gsl_strerror(status));
      exit(1);
    }

    status = gsl_spline_eval_e(Spline_eval_limbdark, u_test, xacc_1d, &Itot);
    if (status)
    {
      printf("File %s\n", __FILE__);
      printf("Error at line %d: %s\n", __LINE__, gsl_strerror(status));
      exit(1);
    }

    if (P > 1)
    {
      printf("%lf %lf %5.4e\n", u_test, P, Itot);
    }

    /*  Ir = 1 / 2. * Itot * (1 + P);
      Il = 1 / 2. * Itot * (1 - P);
  */
  }
}