#include "iteration_functions.h"

#define size 100

int good_j, good_k, n;

/*==================================================================================*/

void collect_photons(double ene, double* k, double* array_ene, double** array_counts, int flag)
{
  double center_ene;
  double delta_ene;

  double total_counts;
  double counts;

  int i, j;
  double kz;

  if (k[2] < 0)
  {
    kz = -k[2];
  }
  else
  {
    kz = k[2];
  }

  // =====================================================================#
  // Define the array of the total counts
  // =====================================================================#

  static int array_total_counts[NSTEP_ENE];

  // =====================================================================#
  // Loop on energies
  // =====================================================================#

  for (i = 0; i < nstepangles; i++)
  {
    if (array_ubounds[i] < -1 || array_ubounds[i] > 1)
    {
      printf("Error bounds %d %lf \n", i, array_ubounds[i]);
    }
  }

  for (i = 0; i < NSTEP_ENE; i++)
  {
    if ((ene >= array_ene[i]) && (ene < array_ene[i + 1]))
    {
      // =====================================================================#
      // If the parameter nstepangles is not set, then the total
      // spectrum is collected and exit from the loop over energy
      // Otherwise make additional loop over the polar angle defined
      // by array_u
      // =====================================================================#

      if (nstepangles < 2)
      {
        break;
      }
      else
      {
        for (j = 0; j < nstepangles; j++)
        {
          if (kz <= array_ubounds[j] && kz > array_ubounds[j + 1])
          {
            good_j = j;

            array_counts[i][good_j]++;

            break;
          }
        }
      }

      // Else condition for photon energy within the boundaries defined by array_ene
    }
    else
    {
      continue;
    }

    // End of loop over energy
  }

  if (flag == 1)
  {
    dat_spectrum = fopen(outspec, "w");

    if (dat_spectrum == NULL)
    {
      printf("Error opening file %s\n", outspec);
      exit(1);
    }

    // ===========================================================================
    /*Compute the total spectrum summed over all angles*/
    // ===========================================================================

    for (i = 0; i < NSTEP_ENE; i++)
    {
      for (j = 0; j < nstepangles; j++)
      {
        array_total_counts[i] = array_total_counts[i] + array_counts[i][j];
      }
    }

    // ====================================================================================
    // Print spectra values, both total and, if set, also angle-dependent
    // ====================================================================================

    for (i = 0; i < NSTEP_ENE - 1; i++)
    {
      center_ene = 0.5 * (array_ene[i + 1] + array_ene[i]);
      delta_ene = 0.5 * (array_ene[i + 1] - array_ene[i]);

      // ====================================================================================
      // Total counts per keV
      // ====================================================================================

      total_counts = array_total_counts[i] / (array_ene[i + 1] - array_ene[i]);

      fprintf(dat_spectrum, "%5.3e  %5.3e  %5.3e ", center_ene, delta_ene, total_counts * center_ene);

      for (j = 0; j < nstepangles; j++)
      {
        nph = 0;

        // ====================================================================================##
        // Print the columns with angle-dependent spectra spectrum in the file
        // ====================================================================================##

        counts = array_counts[i][j] / (array_ene[i + 1] - array_ene[i]);
        nph = nph + array_counts[i][j];

        if (j < nstepangles - 1)
        {
          fprintf(dat_spectrum, " %5.4e ", counts * center_ene);
        }
        else
        {
          fprintf(dat_spectrum, " %5.4e\n", counts * center_ene);
        }
      }
    }

    fclose(dat_spectrum);

  } // End of flag condition for actually producing the qdp file

  // End of program
}
