#include "iteration_functions.h"

#define NR_END 1

double** dmatrix(long nrl, long nrh, long ncl, long nch)
/* allocate a double matrix with subscript range m[nrl..nrh][ncl..nch] */
{
  long i, nrow = nrh - nrl + 1, ncol = nch - ncl + 1;
  double** m;

  /* allocate pointers to rows */
  m = (double**)malloc((size_t)((nrow + NR_END) * sizeof(double*)));

  if (m == NULL)
  {
    printf("Error while allocating memory for 2D matrix, file %s\n", __FILE__);
    exit(1);
  }

  m += NR_END;
  m -= nrl;

  /* allocate rows and set pointers to them */
  m[nrl] = (double*)malloc((size_t)((nrow * ncol + NR_END) * sizeof(double)));
  if (!m[nrl])
  {
    printf("Allocation failure 2 in matrix()");
    exit(1);
  }

  m[nrl] += NR_END;
  m[nrl] -= ncl;

  for (i = nrl + 1; i <= nrh; i++)
    m[i] = m[i - 1] + ncol;

  /* return pointer to array of pointers to rows */
  return m;
}
