#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>
#include <local_header.h>
#include <synchrotron.h>

#define NUM_SAMPLES 400000
#define BURN_IN 1000  // Numero di iterazioni di "bruciatura"
#define INITIAL_X 0.29  // Valore iniziale di x (deve essere positivo)
#define INITIAL_Y 0  // Valore iniziale di y (deve essere positivo)

#define MIN_X 0.1
#define MAX_X 10.0  // Massimo valore di x

#define MIN_Y -5 // Massimo valore di y
#define MAX_Y 5  // Massimo valore di y


double acceptance_ratio(double x_new, double x_old, double y_new, double y_old);
void metropolis_gibbs_sampling(double* x, double* y, int Nburns);


/*====================================================================================*/

double acceptance_ratio(double x_new, double x_old, double y_new, double y_old) 
{
    double z_new;
    double z_old;
    double FlagValue;

    z_new = Psync_total(x_new, y_new);
    z_old = Psync_total(x_old, y_old);

    if (z_new > z_old || clock_random() < z_new / z_old)
    {
    	FlagValue=1;
    }
    else
    {
    	FlagValue=0;
    }

    return FlagValue;


}

/*====================================================================================*/
void metropolis_gibbs_sampling(double* x_sample, double* y_sample, int Nburns) {


	int ii;
    double x = INITIAL_X;
    double y = INITIAL_Y;

    double x_new;
    double y_new;
    double acceptance_x;
    double acceptance_y;

    for (ii = 0; ii <= Nburns; ii++)
    {
    	/*===================================================*/
        // Campiona x utilizzando il Metropolis step
    	/*===================================================*/
        do 
        {
            x_new = x + (clock_random() - 0.5);  // Propone un nuovo valore di x
        }
        while (x_new < MIN_X || x_new > MAX_X);

        acceptance_x = acceptance_ratio(x_new, x, y, y);

        if (acceptance_x==1)
            x = x_new;

        /*===================================================*/
        // Campiona y utilizzando il Metropolis step
        /*===================================================*/

        do 
        {
            y_new = y + (clock_random() - 0.5);  // Propose un nuovo valore di y
        }
        while (y_new < MIN_Y || y_new > MAX_Y);

        acceptance_y = acceptance_ratio(x, x_new, y_new, y);

        if (acceptance_y==1)
            y = y_new;

        /*===================================================*/
        // Salva il campione dopo il periodo di "bruciatura"
        /*===================================================*/

        if (ii == Nburns)
        {
        	*x_sample = x;
        	*y_sample = y;
        }
    }
}



int main()
{

	int ii;
	double energy=0;
	double csi=0;

	for (ii=0; ii< 150000; ii++)
	{
		metropolis_gibbs_sampling(&energy, &csi, 50);
		printf("%lf %lf  %5.4e\n", energy, csi, Psync_total(energy, csi));
	}


    return 0;
}
