#!/usr/bin/env python3
import math
import numpy as np
import sys
import os


#==============================================================

if len(sys.argv) < 4:
    print("\nScript to create the polarization_structure.h of the MC ray-tracing code")
    print("Synopsis: make_header_polar.py emin=emin emax=emax  nbin=nbin\n")
    os.sys.exit()




for inputval in sys.argv:

    if inputval.startswith('emin') == True:
        emin = float(inputval[inputval.rfind('=') + 1:])

    if inputval.startswith('emax') == True:
        emax = float(inputval[inputval.rfind('=') + 1:])

    if inputval.startswith('nbin') == True:
        nbin = int(inputval[inputval.rfind('=') + 1:])




#==============================================================

array_energy=np.zeros(nbin)
ymin = math.log(emin / 511.)
ymax = math.log(emax / 511.)

hy = (ymax - ymin) / (nbin - 1)
y = ymin

c_array="static const double ene_bound[POLAR_NBOUNDS]={"
for ii in range(nbin):

    energy=math.exp(y)

    array_energy[ii]=energy*511
    if ii == nbin-1:
        final_string="};"
    else:
        final_string=", "

    c_array=c_array+str(round(array_energy[ii],3))+final_string

    y = y + hy

#===========================================================
output="polarization_structure.h"
f = open(output, "w")

f.write("#ifndef POLARIZATION_STRUCTURE_H_ \n")
f.write("#define POLARIZATION_STRUCTURE_H_ \n\n")

f.write("#include <functions.h>\n\n")

f.write("#define POLAR_NBOUNDS %d\n\n" % (nbin))

f.write(c_array)
f.write("\n\n\n\n")

f.write("typedef struct {\n\n")

f.write("double* array_Is;\n")
f.write("double* array_Qs;\n")
f.write("double* array_Us;\n")

f.write("double* polar_degree;\n")
f.write("double* csi_angle;\n")

f.write("uint32_t *counter;\n\n")


f.write("} stokes_parameters;\n\n\n")

f.write("#endif\n")

f.close()

#===========================================================

print('Written file', output)