	
<!-- PROJECT LOGO -->
<br />
<p align="CENTER">
  <a href="https://www.ict.inaf.it/gitlab/proton_response_matrix/xmm-newton-proton-response-files">
    <img src="./logos/AHEAD2020_logo.png" alt="AHEAD2020_logo" height="130">
     <img src="./logos/HORIZON2020_logo.png" alt="HORIZON_logo" height="130">
     <img src="./logos/INAF_logo.png" alt="INAF_logo" height="130">
  </a>
  <h3 align="center">XMM-Newton proton response files</h3>

</p>



<!-- TABLE OF CONTENTS -->
## Table of Contents

* [About the Project](#about-the-project)
  * [Documentation](#documentation)
  * [Built with](#built-with)
  * [Download](#download)
* [Usage](#usage)
  * [Validity ranges](#validity-ranges)
* [License](#license)
* [Contact](#contact)
* [How to cite this work](#cite)
* [Acknowledgements](#acknowledgements)



<!-- ABOUT THE PROJECT -->
## About The Project

AHEAD2020 · Horizon 2020 Research and Innovation Programme · GA 871158
WP 9.8 "Understanding the interaction between soft protons and X-ray mirrors"

* Authors: V.Fioretti(1), T. Mineo(2), R. Amato(2), S. Lotti(3), C. Macculi(3), S. Molendi(4), F. Gastaldello(4), G. Lanzuisi(1), M. Cappi(1), M. Dadina(1), S. Ettori(1)
(1)INAF OAS Bologna, (2)INAF IASF Palermo, (3)INAF IAPS Roma, (4)INAF IASF Milano 

* Description: The proton response matrix for the XMM-Newton telescope is composed by a Redistribution Matrix File (RMF)
mapping the proton energy space (from 2 to 300 keV) into detector pulse height and an Auxiliary Response File (ARF) 
collecting the grasp of the optics, the filter transmission efficiency and the detector quantum efficiency. A PATTERN selection of 0 (only events that generate 1 pixel or Singles counts) is used.

* The files are formatted according to the NASA OGIP (Office of Guest Investigators Program) calibration database (caldb) format, and they are tested with the NASA HEASARC XSPEC analysis software tool.

### Documentation

The detailed description of the activity, including the verification and validation, can be found in the [WP 9.8 Technical Note](https://www.ict.inaf.it/gitlab/proton_response_matrix/xmm-newton-proton-response-files/-/blob/main/docs/AHEAD2020_WP9.8_SOFTPROTONS_report_FINAL_v1.2.pdf).



### Built with
The current release of the proton response files is based on:
* Geant4 v10.4 [Agostinelli et al. NIMPA, 506, 250, 2003; Allison et al. ITNS, 53, 270, 2006; Allison et al. NIMPA, 835, 186, 2016]
* BoGEMMS v2.1 [Fioretti et al., Proc. SPIE, 106993J 2018]
* Ray-tracing Monte Carlo code [Mineo et al., Exp. Astr., 44, 287, 2017] 

### Download

Official releases of the response files can be downloaded [here](https://www.ict.inaf.it/gitlab/proton_response_matrix/xmm-newton-proton-response-files/-/releases).


<!-- USAGE -->
## Usage

* The RMF and ARF files can be loaded with any X-ray analysis software compliant with the NASA caldb format.
* Since the accuracy of the Geant4 modeling of the proton stopping power degrades below 1 keV (20% at 1 keV reported in the Geant4 Physics Reference Manual), the energy redistribution is modelled from 1 keV to the upper threshold of the instrument X-ray RMF.
* contrary to the X-ray ARFs, the proton ARF stores the grasp, in cm2 sr. For this reason, the input proton model obtained by deconvolving the observed spectrum with the response files is in units of protons/s/keV/sr.
* The spectra obtained from the response files are normalized for the simulated detection area, stored in the header of the response files. This area can be different from the actual detection area and the observed spectra must be corrected in order to be normalized for the simulated and not the in-flight observation area.
* The response files are available for three optical filters: 
  * thin: 0.16 um of polyimide and 0.04 um of aluminium
  * medium: 0.16 um of polyimide and 0.08 um of aluminium
  * thick: 0.33 um of polypropylene, and 0.11 um of aluminium, and 0.045 um of tin

* The best-fit model is in units of protons/s/keV/sr normalised for the full detection area
* The model to be used is a power-law corrected with a black-body at low energy
  * select at E > 5 keV
  * fit with only the power-law
  * fix the power-law and add the blackbody for the fit in the full-energy range
  * simultaneous MOS and pn observations help to constrain the fit


### Validity ranges

Due to biases at the boundary of the RMF modeling, induced by features in the interpolation because of limited statistics in the simulation, the spectral analysis must be performed within the following intervals:
* MOS: 2 - 11.5 keV
* PN: 2 - 19.5 keV


<!-- LICENSE -->
## License

* Copyright (C) 2022 INAF - see [LICENSE.rst](https://www.ict.inaf.it/gitlab/proton_response_matrix/xmm-newton-proton-response-files/-/blob/main/LICENSE/LICENSE.rst)

<!-- CONTACT -->
## Contact

Valentina Fioretti (INAF OAS Bologna) - valentina.fioretti<at>inaf.it
Project Link: [https://ahead.iaps.inaf.it/](https://ahead.iaps.inaf.it/)

<!-- CITE -->
## How to cite this work

Please make sure to cite the following papers if you use the proton response files:

- [V. Fioretti et al., "Unveiling the origin of XMM-Newton soft proton flares I. Design and validation of a response matrix for proton spectral analysis", A&A, 691, A229 (2024)](https://www.aanda.org/articles/aa/full_html/2024/11/aa51231-24/aa51231-24.html)
- [T. Mineo et al., "Unveiling the origin of XMM-Newton soft proton flares II. Systematics in the proton spectral analysis", A&A, 691, A230 (2024)](https://www.aanda.org/articles/aa/full_html/2024/11/aa51232-24/aa51232-24.html)

<!-- ACKNOWLEDGEMENTS -->
## Acknowledgements
The research leading to these results has received funding from the European Union’s Horizon 2020 Programme under the AHEAD2020 project (grant agreement n. 871158).


