# CALIPSO - Combining mAchine Learning and optImization for Planetary remote Sensing missiOns

## Description
In recent years, more and more attention has been paid from government space agencies such as NASA, ESA and CNSA on the exploration of space beyond Earth. Several missions involved the Moon first, and then Mars, Venus, Jupiter, Saturn and Mercury.  Hence, space missions have been increasingly studied from both technical and strategic points of view.

This research refers to a specific aspect of space mission management, namely the scheduling of the activities of the orbiters. Since space missions are expensive, have limited resources and often exploit old technologies (missions can last for decades), it is really important to make optimized plans for the activities onboard and also to make effective use of the huge amount of data produced from the mission itself. In particular,  our attention will be focused on a very common and important task in space missions, the sounding activity (or observation activity) of ground targets. To address this problem, this project aims at integrating two well-known and powerful disciplines of AI, operation research (OR) and machine learning (ML), in order to build an effective, flexible and dynamic scheduler. Techniques from these two research areas will be adapted to deal with the specific characteristics and constraints of spacecrafts and instruments onboard. This strong interconnection between these research areas and their application to the challenging domain of planetary remote sensing represents the strength and originality of the proposal. Hereby, ML will be devoted to the study of data collected from the missions, and specifically about the observations performed by the radar. At the same time, OR algorithms will address the problem of scheduling of observations in the complex context of space exploration, taking into account the outcome of ML algorithms.

The research carried out in the project aims to fulfill four main goals. (i) First, the project aims to develop an effective, flexible and comprehensive optimization algorithm to support the planning work of teams in ground stations that control space missions. (ii) Second, the project aims to exploit the potential of ML to understand some insight of the phenomena happening in space , to both guide the optimization and to retrieve useful information in general. (iii) Third, the project intends to include the uncertainty and dynamicity of space missions in the optimization approach, by developing specific advanced algorithms.  (iv) Finally,  the project will develop a user-friendly  tool, in order to have a concrete impact on the operational activities of controlling space missions. 

To deal with goals (i),(ii) and (iii) we will divide this project into two main parts. In the first one, we will concentrate on a specific mission, active since 2003 and for which we have already collected a large amount of data: Mars Express. Within this scenario, we will study the scheduling of observations of the Marsis radar. Then, we will move on a second mission less defined and with greater uncertainty, with the ambitious goal to adapt and apply the developed tool in a different, challenging context, such as the JUpiter ICy moons Explorer (JUICE) mission.
