""" 

Context : SRP
Module  : Pipeline.REM
Version : 1.2.3
Author  : Stefano Covino
Date    : 10/06/2016
E-mail  : stefano.covino@brera.inaf.it
URL:    : http://www.merate.mi.astro.it/utenti/covino

Usage   : to be imported

Remarks :

History : (20/08/2013) First version.
        : (21/08/2013) Better limits.
        : (25/08/2013) Better strategy.
        : (30/08/2013) Different strategy for different cameras.
        : (04/09/2013) Refined strategies.
        : (06/09/2013) More stars for REMIR.
        : (10/05/2016) Better porting.
"""

from . import REMPipelineManagerConstants
from SRP.SRPSystem.Pipe import Pipe


res = {'nsrc' : 7, 'ncat' : 5, 'box' : 0.5, 'steps' : 6, 'ang': '0 45 90'}


def AstroDeepness (mjdobs,camera,lim1=0.5,lim2=12,lim3=24,lim4=48):
    cmd = REMPipelineManagerConstants.calend + ' -n '
    cal = Pipe(cmd)
    if cal == None:
        res['nsrc'] = 7
        res['ncat'] = 5
        res['box'] = 0.15
        res['steps'] = 1
        res['ang'] = '0'
        return res
    else:
        nmjd = float(cal.split()[1])
        if camera == REMPipelineManagerConstants.REMIR or camera == REMPipelineManagerConstants.ROSS:    
            if ((nmjd - mjdobs)*24.) <= lim1:
                res['nsrc'] = 20
                res['ncat'] = 15
                res['box'] = 0.3
                res['steps'] = 4
                res['ang'] = '0 45 90'
                return res
            elif lim1 < ((nmjd - mjdobs)*24.) <= lim2:
                res['nsrc'] = 20
                res['ncat'] = 10
                res['box'] = 0.3
                res['steps'] = 4
                res['ang'] = '0 45 90'
                return res
            elif lim2 < ((nmjd - mjdobs)*24.) <= lim3:
                res['nsrc'] = 15
                res['ncat'] = 10
                res['box'] = 0.25
                res['steps'] = 3
                res['ang'] = '0 45 90'
                return res
            elif lim3 < ((nmjd - mjdobs)*24.) <= lim4:
                res['nsrc'] = 10
                res['ncat'] = 10
                res['box'] = 0.25
                res['steps'] = 3
                res['ang'] = '0 90'
                return res
            else:
                res['nsrc'] = 7
                res['ncat'] = 5
                res['box'] = 0.2
                res['steps'] = 1
                res['ang'] = '0'
                return res
        elif camera == REMPipelineManagerConstants.ROS2:    
            if ((nmjd - mjdobs)*24.) <= lim1:
                res['nsrc'] = 20
                res['ncat'] = 10
                res['box'] = 0.25
                res['steps'] = 3
                res['ang'] = '0 45 90'
                return res
            elif lim1 < ((nmjd - mjdobs)*24.) <= lim2:
                res['nsrc'] = 15
                res['ncat'] = 10
                res['box'] = 0.25
                res['steps'] = 3
                res['ang'] = '0 45 90'
                return res
            elif lim2 < ((nmjd - mjdobs)*24.) <= lim3:
                res['nsrc'] = 10
                res['ncat'] = 10
                res['box'] = 0.25
                res['steps'] = 3
                res['ang'] = '0 45 90'
                return res
            elif lim3 < ((nmjd - mjdobs)*24.) <= lim4:
                res['nsrc'] = 10
                res['ncat'] = 10
                res['box'] = 0.2
                res['steps'] = 2
                res['ang'] = '0 90'
                return res
            else:
                res['nsrc'] = 7
                res['ncat'] = 5
                res['box'] = 0.2
                res['steps'] = 1
                res['ang'] = '0'
                return res
#

