""" 

Context : SRP
Module  : Pipeline.REM
Version : 1.3.0
Author  : Stefano Covino
Date    : 30/11/2020
E-mail  : stefano.covino@brera.inaf.it
URL:    : http://www.merate.mi.astro.it/utenti/covino

Usage   : to be imported

Remarks :

History : (07/09/2012) First version.
        : (21/04/2013) Error in data format corrected.
        : (28/08/2013) Possibility to have offsets wrt a given pixel couple.
        : (03/09/2013) Parallactic angle.
        : (10/05/2016) Better porting.
        : (18/05/2017) Minor update.
		: (30/11/2020) WCS update.
"""


import math

from SRPFITS.Fits.GetHeader import GetHeader
from SRPFITS.Fits.GetWCS import GetWCS
from SRPREM.GetREMSite import GetREMSite
from SRPREM.GetObj import GetObj
from . import REMPipelineManagerConstants as RPMC
from .GetLSMeteoInfo import GetLSMeteoInfo
from .GetREMPointingData import GetREMPointingData
from SRP.SRPSky.ParallacticAngle import ParallacticAngle




def ComputeREMAltAz (filename, center=None):
    head = GetHeader(filename)[0]
    wcs = GetWCS(filename)[0]
    if head == None or wcs == None:
        return None, None, None, None, None
    #
    try:
        ra = head[RPMC.RA]
        dec = head[RPMC.DEC]
        dobs = head[RPMC.DOBS]
        mjd = head[RPMC.MJD]
    except KeyError:
        return None, None, None, None, None
    #
    point = GetREMPointingData(mjd+RPMC.JD2MJD)
    #
    if center == None:
#        rac,decc = wcs.getCentreWCSCoords()
        rac,decc = wcs.all_pix2world(wcs.array_shape[0]/2,wcs.array_shape[1]/2,0)
    else:
#        rac,decc = wcs.pix2wcs(center['x'],center['y'])
        rac,decc = wcs.all_pix2world(center['x'],center['y'],0)
    #
    site = GetREMSite()
    site.date = dobs.replace('T',' ').replace('-','/')
    temp,press = GetLSMeteoInfo(mjd+RPMC.JD2MJD)
    site.pressure = press
    site.temp = temp
    #
    nb = GetObj(ra,dec)
    nb.compute(site)
    AZ = math.degrees(float(nb.az))
    ALT = math.degrees(float(nb.alt))
    #
    nb = GetObj(rac,decc)
    nb.compute(site)
    AZc = math.degrees(float(nb.az))
    ALTc = math.degrees(float(nb.alt))
    #
    pang =  ParallacticAngle(nb,site)
    #
    return AZ,ALT,AZc,ALTc,point,pang

    
