""" 

Context : SRP
Module  : Pipeline.py
Version : 1.0.0
Author  : Stefano Covino
Date    : 14/11/2010
E-mail  : stefano.covino@brera.inaf.it
URL:    : http://www.merate.mi.astro.it/utenti/covino

Usage   : to be imported

Remarks :

History : (14/11/2010) First version.

"""


FLPATH = '/home/remguest/REMOS/newsupport/Merate/desk/LOGS/REMMNGR.target'



def GetGRBInfo (grb):
    try:
        f = open(FLPATH)
        dt = f.readlines()
        f.close()
    except IOError:
        return None
    #
    # arcsec
    minerr = 1000.0 
    InGRB = False
    for e in dt:
        el = e.split()
        if len(el) > 8:
            gname = el[4]
            try:
                gra = float(el[5])
                gdec = float(el[6])
                gerr = float(el[7])*3600.0
                ggrbt = float(el[9])
            except ValueError:
                break
            #
            if gname == grb and gerr <= minerr:
                fname = gname
                fra = gra
                fdec = gdec
                ferr = gerr
                fgrbt = ggrbt
                minerr = gerr
                InGRB = True
    #
    if InGRB:
        return fname,fra,fdec,ferr,fgrbt
    else:
        return grb,0.,0.,-1.,0.