""" 

Context : SRP
Module  : Pipeline.REM
Version : 1.0.0
Author  : Stefano Covino
Date    : 05/04/2013
E-mail  : stefano.covino@brera.inaf.it
URL:    : http://www.merate.mi.astro.it/utenti/covino

Usage   : to be imported

Remarks :

History : (05/04/2013) First version.

"""

import math



FLPATH = '/home/remguest/REMOS/newsupport/Merate/desk/LOGS/REMLCMT.meteo'
MAXDLY = 0.0069   # about 10 min




def GetLCMeteoInfo (jd):
    ITEMP = -99.0
    try:
        f = open(FLPATH)
        dt = f.readlines()
        f.close()
    except IOError:
        return ITEMP
    #
    oldff = 1e4
    for i in dt:
        il = i.strip().split()
        if len(il) == 14 and il[12] == '1' and il[13] == '1':
            JD = float(il[0])
            dff = math.fabs(jd-JD)
            if dff <= oldff:
                oldff = dff
                li = il
    #
    if oldff <= MAXDLY:
        ITEMP = float(li[4])
    #
    return ITEMP
#

