""" 

Context : SRP
Module  : Pipeline.REM
Version : 1.1.0
Author  : Stefano Covino
Date    : 30/10/2012
E-mail  : stefano.covino@brera.inaf.it
URL:    : http://www.merate.mi.astro.it/utenti/covino

Usage   : to be imported

Remarks :

History : (05/09/2012) First version.
        : (30/10/2012) Better search.

"""

import math



FLPATH = '/home/remguest/REMOS/newsupport/Merate/desk/LOGS/REMLSMT.meteo'
MAXDLY = 0.0069   # about 10 min




def GetLSMeteoInfo (jd):
    TEMP = 0.0
    PRESS = 0.0
    try:
        f = open(FLPATH)
        dt = f.readlines()
        f.close()
    except IOError:
        return TEMP,PRESS
    #
    oldff = 1e4
    for i in dt:
        il = i.strip().split()
        if len(il) == 13 and il[11] == '1' and il[12] == '1':
            JD = float(il[0])
            dff = math.fabs(jd-JD)
            if dff <= oldff:
                oldff = dff
                li = il
    #
    if oldff <= MAXDLY:
        TEMP = float(li[3])
        PRESS = float(li[7])
    #
    return TEMP,PRESS
#

