""" 

Context : SRP
Module  : Pipeline.REM
Version : 1.0.1
Author  : Stefano Covino
Date    : 05/04/2013
E-mail  : stefano.covino@brera.inaf.it
URL:    : http://www.merate.mi.astro.it/utenti/covino

Usage   : to be imported

Remarks :

History : (30/10/2012) First version.
        : (05/04/2013) Float in output.


"""

import math
from . import REMPipelineManagerConstants as RPMC


FLPATH = '/home/remguest/REMOS/newsupport/Merate/desk/LOGS/REMTCS.tcs'
MAXDLY = 0.00694   # about 10 min




def GetREMFocusData (jd):
    try:
        f = open(FLPATH)
        dt = f.readlines()
        f.close()
    except IOError:
        return RPMC.UnknownFocus
    #
    focus = 0.0
    #
    oldff = 1e4
    for i in dt:
        il = i.strip().split()
        if len(il) > 2:
            JD = float(il[0])
            dff = jd-JD
            if 0.0 <= dff and dff <= oldff:
                oldff = dff
                try:
                    focus = float(il[10])
                except ValueError:
                    focus = RPMC.UnknownFocus
    #
    if oldff <= MAXDLY:
        return focus
    else:
        return RPMC.UnknownFocus
    #
#
