""" 

Context : SRP
Module  : Pipeline.py
Version : 2.4.3
Author  : Stefano Covino
Date    : 28/04/2017
E-mail  : stefano.covino@brera.inaf.it
URL:    : http://www.merate.mi.astro.it/utenti/covino

Usage   : to be imported

Remarks :

History : (11/11/2010) First version.
        : (03/04/2011) Based on urllib2
        : (07/04/2011) Timeout in download.
        : (23/03/2012) Timeout in socket.
        : (18/08/2013) Bug in timeout.
        : (19/08/2013) No more binary.
        : (31/08/2013) Better ROS2 integration.
        : (10/05/2016) Better porting.
"""

HTTP = 'http://'
MAXTIME = 120


import urllib.request, urllib.error, urllib.parse, gzip, os, socket

from . import REMPipelineManagerConstants


def GetREMFrame (fitsfilepath,camera,locfile):
    pre = REMPipelineManagerConstants.PreHTTPCmd
    if camera == REMPipelineManagerConstants.ROSS or camera == REMPipelineManagerConstants.ROS2:
        cmd = REMPipelineManagerConstants.BaseBOPathRoss+fitsfilepath+REMPipelineManagerConstants.archext
    elif camera == REMPipelineManagerConstants.REMIR:
        cmd = REMPipelineManagerConstants.BaseBOPathRemir+fitsfilepath+REMPipelineManagerConstants.archext
    r = urllib.request.urlopen(HTTP+REMPipelineManagerConstants.BOAddr+pre+cmd,timeout=MAXTIME)
    if r != None:
        try:
            data = r.read()
            r.close()
        except socket.timeout:
            return None
        try:
            f = open(locfile+REMPipelineManagerConstants.archext,'wb')
            f.write(data)
            f.close()
            f = gzip.open(locfile+REMPipelineManagerConstants.archext,'r')
            funzip = f.read()
            f.close()
            f = open(locfile+REMPipelineManagerConstants.locext,'wb')
            f.write(funzip)
            f.close()
            os.remove(locfile+REMPipelineManagerConstants.archext)
        except IOError:
            return None
        return len(funzip)
    else:
        return None
        
     

    
