""" 

Context : SRP
Module  : Pipeline.py
Version : 1.1.1
Author  : Stefano Covino
Date    : 10/05/2016
E-mail  : stefano.covino@brera.inaf.it
URL:    : http://www.merate.mi.astro.it/utenti/covino

Usage   : to be imported

Remarks :

History : (11/11/2010) First version.
        : (07/04/2011) Timeout in query.
        : (10/05/2016) Better porting.
"""


import http.client, gzip, os

from . import REMPipelineManagerConstants


MAXTIME = 120


def GetREMFrame (fitsfilepath,camera,locfile):
    conn = http.client.HTTPConnection(REMPipelineManagerConstants.BOAddr,timeout=MAXTIME)
    pre = REMPipelineManagerConstants.PreHTTPCmd
    if camera == REMPipelineManagerConstants.ROSS:
        cmd = REMPipelineManagerConstants.BaseBOPathRoss+fitsfilepath+REMPipelineManagerConstants.archext
    elif camera == REMPipelineManagerConstants.REMIR:
        cmd = REMPipelineManagerConstants.BaseBOPathRemir+fitsfilepath+REMPipelineManagerConstants.archext
    conn.request("GET", pre+cmd)
    r = conn.getresponse()
    if r.status == 200:
        data = r.read()
        conn.close()
        try:
            f = open(locfile+REMPipelineManagerConstants.archext,'wb')
            f.write(data)
            f.close()
            f = gzip.open(locfile+REMPipelineManagerConstants.archext,'rb')
            funzip = f.read()
            f.close()
            f = open(locfile+REMPipelineManagerConstants.locext,'wb')
            f.write(funzip)
            f.close()
            os.remove(locfile+REMPipelineManagerConstants.archext)
        except IOError:
            return None
        return len(funzip)
    else:
        return None
        
     

    
