""" 

Context : SRP
Module  : Pipeline.py
Version : 1.3.0
Author  : Stefano Covino
Date    : 13/03/2017
E-mail  : stefano.covino@brera.inaf.it
URL:    : http://www.merate.mi.astro.it/utenti/covino

Usage   : to be imported

Remarks :

History : (28/11/2010) First version.
        : (21/08/2013) Timeout for queries.
        : (28/08/2013) More excpetions for queries.
        : (13/03/2017) Migration to python3.
"""

ROSSINCR = 10
REMIRINCR = 70
TIMEOUT = 60

from SRP.SRPDatabases.readMySQLTable import readMySQLTable


def GetREMFrameInfo (dbaddr,dbname,dbuser,dbpwd,tabname,rossid,remirid):
    #print(dbaddr,dbname,dbuser,dbpwd,tabname,rossid,remirid)
    # ROSS
    cmdsqlpre = "select max(serial) from %s where dithID = 0" % tabname
    t = readMySQLTable(dbaddr,dbname,dbuser,dbpwd,cmdsqlpre)
    #
    maxrossid = t[0][0]
    if rossid == None:
        rossid = maxrossid-1
    #
    if maxrossid-rossid >= ROSSINCR:
        idincr = ROSSINCR
    else:
        idincr = maxrossid-rossid
    #
    rosstab = []
    while rossid+idincr <= maxrossid:
        cmdsql = "select * from %s where ((serial > %d and serial <= %d) and dithID = 0)" % (tabname,rossid,rossid+idincr)
        try:
            t = readMySQLTable(dbaddr,dbname,dbuser,dbpwd,cmdsql)
            rosstab = t
            break
        except Exception:
            idincr = idincr + ROSSINCR
    #
    #
    # REMIR
    cmdsqlpre = "select max(serial) from %s where dithID = 99" % tabname
    t = readMySQLTable(dbaddr,dbname,dbuser,dbpwd,cmdsqlpre)
    #
    maxremirid = t[0][0]
    if remirid == None:
        remirid = maxremirid-1
    #
    if maxremirid-remirid >= REMIRINCR:
        idincr = REMIRINCR
    else:
        idincr = maxremirid-remirid
    #
    remirtab = []
    while remirid+idincr <= maxremirid:
        cmdsql = "select * from %s where ((serial > %d and serial <= %d) and dithID = 99)" % (tabname,remirid,remirid+idincr)
        try:
            t = readMySQLTable(dbaddr,dbname,dbuser,dbpwd,cmdsql)
            remirtab = t
            break
        except Exception:
            idincr = idincr + REMIRINCR
    #
    newtab = []
    for i in rosstab:
        newtab.append(i)
    for i in remirtab:
        newtab.append(i)
    #
    return newtab
    
