""" 

Context : SRP
Module  : Pipeline.py
Version : 1.2.0
Author  : Stefano Covino
Date    : 28/08/2013
E-mail  : stefano.covino@brera.inaf.it
URL:    : http://www.merate.mi.astro.it/utenti/covino

Usage   : to be imported

Remarks :

History : (28/11/2010) First version.
        : (21/08/2013) Timeout for queries.
        : (28/08/2013) More excpetions for queries.
"""

ROSSINCR = 10
REMIRINCR = 70
TIMEOUT = 60

import atpy, MySQLdb


def GetREMFrameInfo (dbaddr,dbname,dbuser,dbpwd,tabname,rossid,remirid):
    # ROSS
    cmdsqlpre = "select max(serial) from %s where dithID = 0" % tabname
    try:
        t = atpy.Table('mysql',host=dbaddr,db=dbname,user=dbuser,passwd=dbpwd,table=tabname,
            type='sql',query=cmdsqlpre, connect_timeout=TIMEOUT)
    except MySQLdb.InternalError:
        return None
    except MySQLdb.OperationalError:
        return None
    #
    maxrossid = t[0][0]
    if rossid == None:
        rossid = maxrossid-1
    #
    if maxrossid-rossid >= ROSSINCR:
        idincr = ROSSINCR
    else:
        idincr = maxrossid-rossid
    #
    rosstab = []
    while rossid+idincr <= maxrossid:
        cmdsql = "select * from %s where ((serial > %d and serial <= %d) and dithID = 0)" % (tabname,rossid,rossid+idincr)
        try:
            t = atpy.Table('mysql',host=dbaddr,db=dbname,user=dbuser,passwd=dbpwd,table=tabname,
                type='sql',query=cmdsql, connect_timeout=TIMEOUT)
            rosstab = t
            break
        except MySQLdb.InternalError:
            return None
        except MySQLdb.OperationalError:
            return None
        except Exception:
            idincr = idincr + ROSSINCR
    #
    #
    # REMIR
    cmdsqlpre = "select max(serial) from %s where dithID = 99" % tabname
    try:
        t = atpy.Table('mysql',host=dbaddr,db=dbname,user=dbuser,passwd=dbpwd,table=tabname,
            type='sql',query=cmdsqlpre, connect_timeout=TIMEOUT)
    except MySQLdb.InternalError:
        return None
    except MySQLdb.OperationalError:
        return None
    #
    maxremirid = t[0][0]
    if remirid == None:
        remirid = maxremirid-1
    #
    if maxremirid-remirid >= REMIRINCR:
        idincr = REMIRINCR
    else:
        idincr = maxremirid-remirid
    #
    remirtab = []
    while remirid+idincr <= maxremirid:
        cmdsql = "select * from %s where ((serial > %d and serial <= %d) and dithID = 99)" % (tabname,remirid,remirid+idincr)
        try:
            t = atpy.Table('mysql',host=dbaddr,db=dbname,user=dbuser,passwd=dbpwd,table=tabname,
                type='sql',query=cmdsql, connect_timeout=TIMEOUT)
            remirtab = t
            break
        except MySQLdb.InternalError:
            return None
        except MySQLdb.OperationalError:
            return None
        except Exception:
            idincr = idincr + REMIRINCR
    #
    newtab = []
    for i in rosstab:
        newtab.append(i)
    for i in remirtab:
        newtab.append(i)
    #
    return newtab
    
