""" 

Context : SRP
Module  : Pipeline.REM
Version : 1.2.
Author  : Stefano Covino
Date    : 05/08/2014
E-mail  : stefano.covino@brera.inaf.it
URL:    : http://www.merate.mi.astro.it/utenti/covino

Usage   : to be imported

Remarks :

History : (07/09/2012) First version.
        : (18/10/2012) Better search.
        : (30/10/2012) Even better search.
        : (11/08/2013) Unknown pointing state better managed.
        : (05/08/2014) Porting to Pilar3.
"""

import math
from . import REMPipelineManagerConstants as RPMC


FLPATH = '/home/remguest/REMOS/newsupport/Merate/desk/LOGS/REMTCS.tcs'
MAXDLY = 0.00694   # about 10 min




def GetREMPointingData (jd):
    try:
        f = open(FLPATH)
        dt = f.readlines()
        f.close()
    except IOError:
        return RPMC.UnknownPointing
    #
    point = '-1'
    #
    oldff = 1e4
    for i in dt:
        il = i.strip().split()
        if len(il) > 2:
            JD = float(il[0])
            dff = jd-JD
            if 0.0 <= dff and dff <= oldff:
                oldff = dff
                point = il[18]
    #
    if oldff <= MAXDLY:
        if point == '0':
            return RPMC.FrontPointing
        elif point == '1':
            return RPMC.BackPointing
        else: 
            return RPMC.UnknownPointing
    else:
        return RPMC.UnknownPointing
    #
#
