""" 

Context : SRP
Module  : Pipeline.REM
Version : 1.0.1
Author  : Stefano Covino
Date    : 04/07/2016
E-mail  : stefano.covino@brera.inaf.it
URL:    : http://www.merate.mi.astro.it/utenti/covino

Usage   : to be imported

Remarks :

History : (03/05/2016) First version.
        : (04/07/2016) Different error codes.

"""

import math



FLPATH = '/home/remguest/REMOS/newsupport/Merate/desk/LOGS/REMTCS.tcs'
MAXDLY = 0.01042  # about 15 min




def GetREMTemp (jd):
    ITEMP = -99.0
    try:
        f = open(FLPATH)
        dt = f.readlines()
        f.close()
    except IOError:
        return ITEMP
    #
    oldff = 1e4
    for i in dt:
        il = i.strip().split()
        if len(il) > 2:
            JD = float(il[0])
            dff = math.fabs(jd-JD)
            if dff <= oldff:
                oldff = dff
                try:
                    ITEMP = float(il[16])
                except ValueError:
                    ITEMP = -98.0
    #
    if oldff >= MAXDLY:
        ITEMP = -97.0
    #
    return ITEMP
#

