""" 

Context : SRP
Module  : Pipeline.py
Version : 1.0.0
Author  : Stefano Covino
Date    : 08/11/2010
E-mail  : stefano.covino@brera.inaf.it
URL:    : http://www.merate.mi.astro.it/utenti/covino

Usage   : to be imported

Remarks :

History : (08/11/2010) First version.

"""


from SRP.SRPMath.AstroCoordInput import AstroCoordInput



def LoadREMTargets (fname):
    values = []
    try:
        f = open(fname)
        dt = f.readlines()
        f.close()
    except IOError:
        return None
    #
    for e in dt:
        el = e.split()
        try:
            name = el[0]
            ras = el[1]
            decs = el[2]
        except ValueError:
            return None
        crd = AstroCoordInput(ras,decs)
        values.append((name,crd.RA,crd.DEC))
    #
    return values
