""" Utility functions and classes for SRP

Context : SRP
Module  : REMPipelineManagerConstants.py
Version : 1.6.4
Author  : Stefano Covino
Date    : 30/11/2020
E-mail  : stefano.covino@brera.inaf.it
URL:    : http://www.merate.mi.astro.it/utenti/covino

Usage   : to be imported

Remarks :

History : (01/12/2010) First version.
        : (13/12/2010) New columns for databases.
        : (17/12/2010) New REM alert address.
        : (19/12/2010) New REM alert address.
        : (20/12/2010) Two new database columns.
        : (05/03/2011) New GRB alert e-mail.
        : (28/03/2011) AGN data
        : (26/06/2011) ZP for REMIR filters.
        : (05/09/2012) New constants.
        : (07/09/2012) Pointing constants.
        : (05/04/2013) New ROS2 filters and Focus frames analyzed. TInt and Focus in database.
        : (21/04/2013) New command names.
        : (14/08/2013) New catalogues.
        : (18/08/2013) ROS2 constants.
        : (20/08/2013) Minor changes.
        : (25/08/2013) Astrometry constant updated.
        : (28/08/2013) REM derotation ceneters.
        : (03/09/2013) Derotator offset, parallactic angle and dither wedge position in database.
        : (04/09/2013) Minor improvements.
        : (08/09/2014) Better choice of catalogues for AGN photometry.
        : (10/05/2016) Better porting.
        : (21/02/2017) Python3 porting.
        : (13/03/2017) Update postgres server address.
        : (29/04/2017) New target set to be analyzed.
        : (21/05/2019) New email data.
		: (30/11/2020) New adress for postgres databse.
"""


import os.path
import collections

import SRPPipelines as SP


# Keep memory of the point reached by the pipeline
ProcessPointFName = 'ProcessPoint.dat'



# Pipeline log file
LogFName    =   'REMPipeline.log'
LogDir      =   'SRPREMLogs'
LogPath     =   os.path.join(LogDir,LogFName)



# Catalogue output
CatOutFile  =   'catpipe.dat'
PhotOutFile =   '_photom.dat'




# Local database
DBaseLocDir         =   'SRPREMDBs'
DBaseLocFile        =   'SRPREMPipeline.db'
DBaseLocPath        =   os.path.join(DBaseLocDir,DBaseLocFile)
DBLocTabName        =   'REMPipeResult'
DBLocParDict        =   collections.OrderedDict([(SP.MainDBKey,'text unique'), ('Object','text'), ('Category','text'), ('RA','real'), ('DEC','real'),
                        ('Id', 'int'), ('Instrument', 'text'), ('Filter','text'), ('PhotoNStars','integer'), ('FWHM','real'), 
                        ('ZeroPointMag','real'), ('ZeroPointErr','real'), ('ZeroPointNStars','integer'), ('AZ','real'), ('ALT','real'), 
                        ('ObjMag','real'), ('ObjMagErr','real'), ('CentrMJD','double precision primary key'), ('TrueExp','real'),
                        ('XPos','real'), ('YPos','real'), ('ProcStat','integer'), ('PhotStab','real'), ('AZc','real'), ('ALTc','real'),
                        ('Point','integer'), ('TInt','real'), ('Focus','real'), ('Derotang','real'), ('Dwangle','real'), ('Pangle','real')])
DBHostTabName       =   'REMHostResult'
DBHostParDict       =   collections.OrderedDict([(SP.MainDBKey,'text'), ('Object','text'), ('Instrument', 'text'), ('Filter','text'),
                        ('PhotoNStars','integer'), ('FWHM','real'), ('ZeroPointMag','real'), ('ZeroPointErr','real'), 
                        ('ZeroPointNStars','integer'), ('ObjMag','real'), ('ObjMagErr','real'), ('CentrMJD','double precision primary key'), 
                        ('TrueExp','real'), ('PI','text'), ('XPos','real'), ('YPos','real'), ('ProcStat','integer'), ('PhotStab','real')])



# Remote database
DBaseRemAddr        =   '127.0.0.1'              # local db
DBaseRemDB          =   'covino'
DBaseRemUser        =   'covino'
DBaseRemPwd         =   'Gramigna'
DBaseRemTabName     =   DBLocTabName
DBaseRemParDict     =   DBLocParDict
DBaseHostTabName    =   DBHostTabName
DBaseHostParDict    =   DBHostParDict



# Remote REM observation database
REMDBaseAddr    =   'ross.iasfbo.inaf.it'
REMDBaseDB      =   'REMImgs'
REMDBaseUser    =   'DS_REM'
REMDBasePwd     =   'ds06rem'
REMDBaseTabName =   'Obslog'
REMDBaseId      =   'serial'
REMDBaseRA      =   'radeg'
REMDBaseDEC     =   'decdeg'
REMDBaseObj     =   'object'
REMDBaseObsCode =   'obscode'
REMDBaseDithId  =   'dithID'
REMDBaseFilter  =   'filter'
REMDBaseMJDObs  =   'mjdobs'
REMDBaseExp     =   'exptime'
REMDBaseFName   =   'fname'
REMDBasePI      =   'pi_coi'
REMDBTableList  = (REMDBaseId, REMDBaseRA, REMDBaseDEC, REMDBaseObj, REMDBaseObsCode, REMDBaseDithId, REMDBaseFilter,
        REMDBaseMJDObs, REMDBaseExp, REMDBaseFName, REMDBasePI)
        


# File repository
BOAddr          =   'ross.iasfbo.inaf.it'
BaseBOPathRemir =   '/Remir/ImgsDBArchive/'
BaseBOPathRoss  =   '/Ross/ImgsDBArchive/'
PreHTTPCmd      =   '/REMDB/fits_retrieve.php?ffile='



# File names
archext =   '.fits.gz'
locext  =   '.fits'



# Delay after each iteration
TimeDelay   =   300  # s


# Delay after failed donwload
DwnDelay    =   30


# Difference between Julian and modified Julian dates
JD2MJD      =   2400000.5


# Header of interest for REM
AZ          =   'AZ'
ALT         =   'ALT'
EL          =   'EL'
EXPTIME     =   'EXPTIME'
TMJDOBS     =   'JDMID'
TEXP        =   'T_ELAPSD'
PROCSTAT    =   'PROCSTAT'
PHOTSTAB    =   'PHOTSTAB'
RA          =   'RA'
DEC         =   'DEC'
DOBS        =   'DATE-OBS'
MJD         =   'MJD-OBS'
INSTR       =   'INSTRUME'
DEROTANG    =   'DEROTANG'
DWANGLE     =   'DWANGLE'



# Pipeline components
astro       =   'SRPREMAstrometry'
astrochk    =   'SRPAstrometryCheck'
calend      =   'SRPCalendar'
photo       =   'SRPPhotometry'
param       =   'SRPPhotParSet'
zpoint      =   'SRPZeroPoint'
sigmak      =   'SRPAverSigmaClipping'
query       =   'SRPQuery'
gettab      =   'SRPGetTabEntry'




# REM filter and camera data
REMIR   =   'REMIR'
ROSS    =   'ROSS'
ROS2    =   'ROS2'
g       =   'g'
r       =   'r'
i       =   'i'
z       =   'z'
V       =   'V'
R       =   'R'
I       =   'I'
Z       =   'Z'
J       =   'J'
H       =   'H'
K       =   'K'
REMIRFilterSet  = (Z, J, H, K)
ROSSFilterSet   = (V, R, I, g, r, i, z)
GoodDither      =   99
#
REMFiltColDict = {V : (6,7), R : (8,9), I : (10,11), g : (8,9), r : (10,11), i : (12,13), z : (12,13), Z : (22,23), J : (4,5), H : (6,7), K : (8,9)}
REMFiltCatDict = {V : 'SSC', R : 'SSC', I : 'SSC', g : 'APS', r : 'APS', i : 'APS', z : 'SDSS', Z : 'AWC', J : 'TMC', H : 'TMC', K : 'TMC'}
#
REMFiltColDictAGN = {g : (8,9), r : (10,11), i : (12,13), z : (12,13), V : (4,5), R : (6,7), I : (8,9), Z : (12,13), J : (4,5), H : (6,7), K : (8,9)}
REMFiltCatDictAGN = {g : 'APS', r : 'APS', i : 'APS', z : 'SDSS', V : 'AGNOPT', R : 'AGNOPT', I : 'AGNOPT', Z : 'SDSS', J : 'TMC', H : 'TMC', K : 'TMC'}
#
RossZP = {V : (19.3, 0.1), R : (19.8, 0.1), I : (19.3, 0.1), g : (19.3, 0.1), r : (19.8, 0.1), i : (19.3, 0.1), z : (19.3, 0.1)}
RemirZP = {Z : (18.0, 0.1), J : (18.0, 0.1), H : (18.0, 0.1), K : (18.0, 0.1)}



# REM detector data
ROSSGAIN        = 2.0
ROS2GAIN        = 1.0
ROSSSATURATION  = 55000
REMIRGAIN       = 5.0
REMIRSATURATION = 15000
REMSIZE         = 10



# Frame derotation centers
REMIRDC = {'x': 257, 'y': 350}
ROS2BLDC = {'x': 474, 'y': 640}
ROS2BRDC = {'x': 475, 'y': 643}
ROS2ULDC = {'x': 469, 'y': 642}
ROS2URDC = {'x': 459, 'y': 643}
 

# Extinction coefficients
LaSillaExtCoeff =   {g : 0.163, r : 0.078, i : 0.007, z : 0.00, V : 0.11, R : 0.04, I : 0.01, Z : 0.01, J : 0.00, H : 0.00, K : 0.00}



# REM target categories
GRB1    =   1
GRB2    =   2
STD     =   3
STR     =   4
DK      =   5
FL      =   6
TST     =   7
GRB8    =   8
GRB9    =   9
AGN     =   10
LMXRB   =   11
HMXRB   =   12
FLSTR   =   13
OSC     =   14
GSC     =   15
NBPL    =   17
SNR     =   18
OTHER   =   19
GALXY   =   20
SGR     =   21
IBASSGR =   22
IBASTIB =   23
SWTRG   =   24
SOL     =   25
SN      =   26
NB      =   27
TRT     =   28
TOO     =   29
FCS     =   30
FVR     =   31
SAGTRG  =   32
GGBMTRG =   33
GLATTRG =   34
#OkTargetSet     =   (STD, STR, FCS, TRT, AGN, GRB1, GRB2, GRB8, GRB9)
OkTargetSet     =   (STD, FCS, AGN, GRB1, GRB2, GRB8, GRB9)
GRBTargetSet    =   (GRB1, GRB2, GRB8, GRB9)
REMTargetDict   = {FCS:'FCS', STD:'STD', STR:'STR', TRT:'TRT', AGN:'AGN', GRB1:'GRB', GRB2:'GRB', GRB8:'GRB', GRB9:'GRB'}

            
                                    
# Mail data
REMSMTP     = 'polaris'
FromAdr     = 'stefano.covino@inaf.it'
ToAdr       = ('stefano.covino@inaf.it',)
PipeMsg     = 'REM Pipeline severe problem'
ToGRBAdr    = ('stefano.covino@inaf.it','paolo.davanzo@inaf.it','andrea.melandri@inaf.it')



# Host and user information
AccHost =   'polaris.me.oa-brera.inaf.it'
AccUser =   'covino'



# Target file
TrgFNameAGN     =   'REMPipeAGNTrgs.dat'
TrgFNameVitali  =   'REMPipeVitaliTrgs.dat'
TrgDir          =   'SRPREMTargets'
TrgAGNPath      =   os.path.join(TrgDir,TrgFNameAGN)
TrgVitaliPath   =   os.path.join(TrgDir,TrgFNameVitali)


# REM pointing state
FrontPointing   =   1
BackPointing    =   0
UnknownPointing =   -1
#
UnknownFocus    =   -99.0

PointDict = {FrontPointing : 'Front', BackPointing : 'Back', UnknownPointing : 'Unknown'}

