""" 

Context : SRP
Module  : Pipeline.py
Version : 1.1.1
Author  : Stefano Covino
Date    : 10/06/2016
E-mail  : stefano.covino@brera.inaf.it
URL:    : http://www.merate.mi.astro.it/utenti/covino

Usage   : to be imported

Remarks :

History : (22/11/2010) First version.
        : (31/08/2013) ROS2 recognized.
        : (10/05/2016) Better porting.
"""


from . import REMPipelineManagerConstants



def WhichREMImagingFrame (tabentry):
    if tabentry[REMPipelineManagerConstants.REMDBaseDithId] == REMPipelineManagerConstants.GoodDither:
        return REMPipelineManagerConstants.REMIR
    elif tabentry[REMPipelineManagerConstants.REMDBaseDithId] == 0:
        fn = tabentry[REMPipelineManagerConstants.REMDBaseFName]
        if 'BL' in fn or 'BR' in fn or 'UR' in fn or 'UL' in fn:
            return REMPipelineManagerConstants.ROS2
        else:
            return REMPipelineManagerConstants.ROSS
    else:
        return None
        