""" 

Context : SRP
Module  : Pipelines.REM
Version : 1.1.42
Author  : Stefano Covino
Date    : 12/05/2021
E-mail  : stefano.covino@brera.inaf.it
URL     : http://www.me.oa-brera.inaf.it/utenti/covino


Usage   : to be imported

Remarks :

History : (11/09/2011) First version.
        : (24/03/2012) Better data download management.
        : (05/09/2012) GetLSMeteoInfo and ComputeREMAltAz.
        : (07/09/2012) GetREMPointingData.
        : (30/10/2012) GetREMFocusData.
        : (05/04/2013) Temperature in database and ROS2 data.
        : (21/04/2013) Astrometry in pipeline.
        : (21/06/2013) Better management of wrong dates.
        : (24/06/2013) AUTO photometry for all targets.
        : (09/08/2013) More objects in astrometry computation and V. 1.3.3b1
        : (11/08/2013) Minor bugs and V. 1.3.3b2.
        : (14/08/2013) V. 1.3.3b3.
        : (17/08/2013) V. 1.3.3.
        : (18/08/2013) V. 1.4.0b1.
        : (19/08/2013) V. 1.4.0b2.
        : (20/08/2013) V. 1.4.0.
        : (21/08/2013) V. 1.4.1.
        : (22/08/2013) V. 1.4.2b1.
        : (24/08/2013) V. 1.4.2.
        : (25/08/2013) V. 1.4.3b1.
        : (28/08/2013) V. 1.4.3.
        : (29/08/2013) V. 1.4.4.
        : (30/08/2013) V. 1.4.5b1 and 1.4.5.
        : (31/08/2013) V. 1.4.6.
        : (03/09/2013) V. 1.4.7 and 1.4.8.
        : (04/09/2013) V. 1.4.9.
        : (06/09/2013) V. 1.4.10.
        : (14/01/2014) V. 1.4.11b1.
        : (06/02/2014) V. 1.4.11b2.
        : (05/08/2014) V. 1.4.11.
        : (08/09/2014) V. 1.4.12.
        : (17/12/2014) V. 1.4.13.
        : (10/01/2015) V. 1.4.14.
        : (03/05/2016) V. 1.5.0.
        : (10/05/2016) V. 2.0.0.
        : (08/06/2016) V. 2.0.1.
        : (04/07/2016) V. 2.0.2.
        : (17/02/2017) V. 2.1.0b1.
        : (13/03/2017) V. 2.1.0.
        : (28/04/2017) V. 2.1.1.
        : (29/04/2017) V. 2.1.2.
        : (04/02/2019) V. 2.1.3.
        : (21/05/2019) V. 2.1.4.
		: (30/11/2020) V. 2.1.5.
        : (02/02/2021) V. 2.1.6.
		: (12/05/2021) V. 2.2.0.
"""


__version__ = '2.2.0'


__all__ = ['AstroDeepness', 'ComputeREMAltAz', 'GetGRBInfo', 'GetLCMeteoInfo', 'GetLSMeteoInfo',
           'GetREMFocusData','GetREMFrame', 'GetREMFrameInfo', 'GetREMPointingData', 'GetREMTemp',
           'LoadProcessPointFName', 'LoadREMTargets', 'REMPipelineManagerConstants',
           'SaveProcessPointFName', 'WhichREMImagingFrame']

