package it.inaf.oats.vospace.datamodel;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ivoa.xml.uws.v1.JobSummary.JobInfo;

public class JobInfoSerializer extends StdSerializer<JobInfo> {

    public JobInfoSerializer() {
        super(JobInfo.class);
    }

    @Override
    public void serialize(JobInfo jobInfo, JsonGenerator jg, SerializerProvider sp) throws IOException {

        List<Object> any = jobInfo.getAny();
        if (any == null || any.isEmpty()) {
            jg.getCodec().writeValue(jg, null);
            return;
        }

        if (jobInfo.getAny().size() == 1) {
            Object content = jobInfo.getAny().get(0);

            Map<String, Object> map = new HashMap<>();
            String name = content.getClass().getSimpleName().toLowerCase();
            map.put(name, content);

            jg.getCodec().writeValue(jg, map);
        } else {
            jg.getCodec().writeValue(jg, jobInfo.getAny());
        }
    }
}
