package it.inaf.oats.vospace.datamodel;

import javax.xml.bind.annotation.adapters.XmlAdapter;
import net.ivoa.xml.vospace.v2.Node;

/**
 * JAXB automatically generates the xsi:type attribute, however it doesn't fill
 * it for the root node (it seems that this is by design). Since we need it, we
 * manually added it on the Node class, but this causes a duplication of the
 * attribute in the children nodes. This adapter is applied to children nodes to
 * avoid the duplication by setting the field to null.
 */
public class RemoveDuplicateTypeAdapter extends XmlAdapter<Node, Node> {

    @Override
    public Node unmarshal(Node node) throws Exception {
        return node;
    }

    @Override
    public Node marshal(Node node) throws Exception {
        node.removeType();
        return node;
    }
}
