# VOSpace Data Model

Java classes used for modelling VOSpace entities are used both by REST web service and UI application, so they are kept in a separate software module called VOSpace Data Model:

![vospace-datamodel](vospace-datamodel.jpg)

The main goal of this shared library is to provide a binding between Java classes and XML defined by the VOSpace standard. We are also using `jackson-module-jaxb-annotations` to support both XML and JSON binding. Our REST service supports also JSON payloads (Spring Framework performs content negotiation based on HTTP Accept header).

Some utility methods for extracting information from nodes have also been added.

## Generating beans from XML schema

    cd xsd
    xjc vospace.xsd

### Changes to the online XSD files

It seems that xjc does something wrong when retriving the imported XSD from the web, so the dependent files have been downloaded and relative path has been specified in `schemaLocation` attribute.

In vospace.xsd:

```xml
<xsd:import namespace="http://www.ivoa.net/xml/UWS/v1.0" schemaLocation="./uws.xsd"/>
```

In uws.xsd:

```xml
<xs:import namespace="http://www.w3.org/1999/xlink" schemaLocation="./xlink.xsd"/>
```

### Changes to the generated classes

#### Namespaces issues

In package-info.java files some `@javax.xml.bind.annotation.XmlNs` annotations have been added to serialize the XML keeping the namespaces (vos, xsi, xlink, uws).

To handle the `vos:` prefix in JSON a custom type id resolver (`NodeTypeJsonResolver`) has been added to the `Node` class.

#### Type attribute issue

JAXB automatically generates the `xsi:type` attribute, however it doesn't fill it for the root node (it seems that this is by design). Since we need it, we manually added it on the `Node` class, but this caused a duplication of the attribute in the children nodes. So we added a `removeType()` method that sets it to null. This method is called by a custom adapter (`RemoveDuplicateTypeAdapter`) during the marshalling of the node.

#### JSON inheritance

The `@JsonTypeInfo` annotation has been added to the `Node` class for telling to Jackson that the field type is used to handle inheritance.

#### Root element tag name

2 annotations have been added to each node subtype:

```java
@XmlRootElement(name = "node")
```

`@XmlRootElement` is necessary to parse single nodes. The value `"node"` has been specified because by default the bean would be serialized as `<unstructuredDataNode>` or `<containerNode>` and so on.

#### Handling generic type in JobInfo content

`JobSummary` class has a `jobInfo` field that is a generic object (since it is the payload of UWS jobs). In the case of VOSpace the `jobInfo` is an instance of `Transfer`. To properly serialize this object the following annotation has been added to the `JobSummary` class:

```java
@XmlSeeAlso({Transfer.class})
```

Moreover custom JSON serializer and deserialized have been added on the `JobInfo` class.
