/*
    Author: Sonia Zorba
    Email: sonia.zorba@inaf.it
*/

CREATE INDEX file_name_idx ON node USING btree(name);

CREATE INDEX file_parent_path_gist_idx ON node USING GIST(parent_path);
CREATE INDEX file_parent_path_idx ON node USING btree(parent_path);

ALTER TABLE node ADD COLUMN path ltree GENERATED ALWAYS AS (path(parent_path, node_id)) STORED;
CREATE INDEX file_path_gist_idx ON node USING GIST(path);
CREATE UNIQUE INDEX file_path_idx ON node USING btree(path);

ALTER TABLE node ADD COLUMN relative_path ltree GENERATED ALWAYS AS (path(parent_relative_path, node_id)) STORED;
CREATE INDEX file_rel_path_gist_idx ON node USING GIST(relative_path);
