/*
    Author: Sonia Zorba
    Email: sonia.zorba@inaf.it
*/

-- Generates the path from parent_path and id
CREATE OR REPLACE FUNCTION path(parent_path ltree, id bigint) RETURNS ltree AS
$func$
BEGIN
    RETURN text2ltree(CASE
        WHEN parent_path IS NULL THEN ''
        WHEN parent_path::varchar = '' THEN id::varchar
        ELSE (parent_path::varchar || '.' || id::varchar)
    END);
END
$func$ LANGUAGE plpgsql IMMUTABLE; 

-- Testing the function
SELECT CASE WHEN
path(NULL, 0) = text2ltree('')
AND path(text2ltree(''), 1) = text2ltree('1')
AND path(text2ltree('1'), 2) = text2ltree('1.2')
THEN 'PASSED' ELSE 'FAILED' END AS test;