CREATE TYPE JobPhaseEnum AS ENUM ('PENDING', 'QUEUED', 'EXECUTING', 'ABORTED', 'COMPLETED', 'HELD', 'SUSPENDED', 'ERROR', 'ARCHIVED');
CREATE TYPE JobTypeEnum AS ENUM ('pushToVoSpace', 'pullToVoSpace', 'pullFromVoSpace', 'pushFromVoSpace', 'moveNode', 'copyNode', 'other');

CREATE TABLE job (
    job_id varchar not null,
    owner_id varchar not null,
    job_type JobTypeEnum not null,
    phase JobPhaseEnum not null,
    start_time timestamp,
    end_time timestamp,
    creation_time timestamp default CURRENT_TIMESTAMP,
    job_info jsonb,
    results jsonb,
    primary key(job_id)
);

CREATE INDEX owner_idx ON job USING btree(owner_id);
