/*
    Author: Sonia Zorba
    Email: sonia.zorba@inaf.it
*/

-- Generate the os_path from the node id
-- It could be used for initializing the os_path generated column
CREATE OR REPLACE FUNCTION get_os_path(input_id int) RETURNS varchar AS
$func$
SELECT string_agg(name, '/') FROM (
    WITH RECURSIVE paths AS (
            SELECT node_id, name, path, parent_path, 1 AS level
            FROM node
            WHERE node_id = input_id
        UNION ALL
            SELECT f.node_id, f.name, f.path, f.parent_path, p.level + 1
            FROM node f
            INNER JOIN paths p ON p.parent_path = f.path
    ) SELECT name FROM paths ORDER BY LEVEL DESC
) AS names;
$func$ LANGUAGE sql;
