/*
    Author: Sonia Zorba
    Email: sonia.zorba@inaf.it
*/

CREATE INDEX file_name_idx ON Node USING btree(name);

CREATE INDEX file_parent_path_gist_idx ON Node USING GIST(parent_path);
CREATE INDEX file_parent_path_idx ON Node USING btree(parent_path);

ALTER TABLE Node ADD COLUMN path ltree GENERATED ALWAYS AS (path(parent_path, node_id)) STORED;
CREATE INDEX file_path_gist_idx ON Node USING GIST(path);
CREATE UNIQUE INDEX file_path_idx ON Node USING btree(path);

ALTER TABLE Node ADD COLUMN relative_path ltree GENERATED ALWAYS AS (path(parent_relative_path, node_id)) STORED;
CREATE INDEX file_rel_path_gist_idx ON Node USING GIST(relative_path);
