CREATE TYPE job_phase_enum AS ENUM ('PENDING', 'QUEUED', 'EXECUTING', 'ABORTED', 'COMPLETED', 'HELD', 'SUSPENDED', 'ERROR', 'ARCHIVED');

CREATE TYPE job_type_enum AS ENUM ('pushToVoSpace', 'pullToVoSpace', 'pullFromVoSpace', 'pushFromVoSpace', 'moveNode', 'copyNode', 'other');

CREATE TABLE job (
    job_id varchar not null,
    owner_id varchar not null,
    job_type job_type_enum not null,
    phase job_phase_enum not null,
    start_time timestamp,
    end_time timestamp,
    job_info jsonb,
    results jsonb,
    primary key(job_id)
);

CREATE INDEX owner_idx ON job USING btree(owner_id);
