/*
    Author: Sonia Zorba
    Email: sonia.zorba@inaf.it
*/

-- This view allows to obtain the the ltree_path from the os_path
-- Example query:
-- SELECT path FROM node n JOIN node_os_path o ON n.node_id = o.node_id WHERE os_path = '/curban/store';

CREATE VIEW node_os_path AS
SELECT node_id, '/' AS os_path FROM node WHERE path = ''
UNION
SELECT node_id, '/' || string_agg(name, '/') AS os_path
FROM (
    SELECT (CASE WHEN os_name IS NOT NULL THEN os_name ELSE name END) AS name, p.node_id
    FROM node n
    JOIN (
        SELECT UNNEST(string_to_array(relative_path::varchar, '.')) AS rel_id, node_id
        FROM node
    ) AS p ON n.node_id::varchar = p.rel_id
    ORDER BY p.node_id, nlevel(n.path)
) AS j GROUP BY node_id;

-- View that maps node_id to vos_path

CREATE VIEW node_vos_path AS
SELECT node_id, '/' AS vos_path FROM node WHERE path = ''
UNION
SELECT node_id, '/' || string_agg(name, '/') AS os_path
FROM (
    SELECT name, p.node_id
    FROM node n
    JOIN (
        SELECT UNNEST(string_to_array(path::varchar, '.')) AS rel_id, node_id
        FROM node
    ) AS p ON n.node_id::varchar = p.rel_id
    ORDER BY p.node_id, nlevel(n.path)
) AS j GROUP BY node_id;

-- This view allows to obtain the the os_path from the vos_path

CREATE VIEW node_path AS
SELECT v.node_id, vos_path, os_path
FROM node_vos_path v
LEFT JOIN node_os_path o ON o.node_id = v.node_id;
