package it.inaf.ia2.transfer;

import it.inaf.ia2.aa.jwt.JwksClient;
import it.inaf.ia2.aa.jwt.TokenParser;
import it.inaf.ia2.transfer.auth.TokenFilter;
import java.net.URI;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;

@SpringBootApplication
public class FileServiceApplication {

    @Value("${jwks_uri}")
    private String jwksUri;

    public static void main(String[] args) {
        SpringApplication.run(FileServiceApplication.class, args);
    }

    @Bean
    public TokenParser tokenParser() {
        JwksClient jwksClient = new JwksClient(URI.create(jwksUri));
        return new TokenParser(jwksClient);
    }

    @Bean
    public FilterRegistrationBean tokenFilterRegistration(TokenParser tokenParser) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter(new TokenFilter(tokenParser));
        registration.addUrlPatterns("/*");
        return registration;
    }
}
