package it.inaf.ia2.transfer.persistence;

import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class ListOfFilesDAO {

    private final JdbcTemplate jdbcTemplate;

    @Autowired
    public ListOfFilesDAO(DataSource fileCatalogDatasource) {
        this.jdbcTemplate = new JdbcTemplate(fileCatalogDatasource);
    }

    public void createList(String vosListNodePath, List<String> vosPaths) {

        List<NodeIdPath> idPaths = getAllNodeIdPaths(vosListNodePath, vosPaths);

        if (idPaths.size() != (vosPaths.size() + 1)) {
            throw new IllegalStateException("Unable to retrieve some file identifiers from paths");
        }

        Integer listNodeId = null;

        List<Integer> nodeIds = new ArrayList<>();
        for (NodeIdPath idPath : idPaths) {
            if (vosListNodePath.equals(idPath.nodePath)) {
                listNodeId = idPath.nodeId;
            } else {
                nodeIds.add(idPath.nodeId);
            }
        }

        if (listNodeId == null) {
            throw new IllegalStateException("List node id not found for path " + vosListNodePath);
        }

        createList(listNodeId, nodeIds);
    }

    private List<NodeIdPath> getAllNodeIdPaths(String vosListNodePath, List<String> vosPaths) {
        List<String> allPaths = new ArrayList<>(vosPaths);
        allPaths.add(vosListNodePath);

        String sql = "SELECT node_id, vos_path FROM node_vos_path WHERE vos_path IN ("
                + String.join(",", Collections.nCopies(allPaths.size(), "?")) + ")";

        return jdbcTemplate.query(conn -> {
            PreparedStatement ps = conn.prepareStatement(sql);
            int i = 0;
            for (String path : allPaths) {
                ps.setString(++i, path);
            }
            return ps;
        }, (row, index) -> {
            NodeIdPath nodeIdPath = new NodeIdPath();
            nodeIdPath.nodeId = row.getInt("node_id");
            nodeIdPath.nodePath = row.getString("vos_path");
            return nodeIdPath;
        });
    }

    private void createList(int listNodeId, List<Integer> nodes) {

        String sql = "INSERT INTO list_of_files (list_node_id, node_id) VALUES "
                + String.join(",", Collections.nCopies(nodes.size(), "(?, ?)"));

        jdbcTemplate.update(conn -> {
            PreparedStatement ps = conn.prepareStatement(sql);
            int i = 0;
            for (int nodeId : nodes) {
                ps.setInt(++i, listNodeId);
                ps.setInt(++i, nodeId);
            }
            return ps;
        });
    }

    static class NodeIdPath {

        int nodeId;
        String nodePath;
    }
}
