/*
 * This file is part of vospace-file-service
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.ia2.transfer.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import it.inaf.ia2.transfer.auth.TokenPrincipal;
import it.inaf.ia2.transfer.service.ArchiveJob;
import it.inaf.ia2.transfer.service.ArchiveService;
import java.io.File;
import java.nio.file.Files;
import java.util.Arrays;
import static org.junit.jupiter.api.Assertions.assertEquals;
import org.junit.jupiter.api.Test;
import static org.mockito.ArgumentMatchers.any;
import static org.mockito.ArgumentMatchers.argThat;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.MockMvc;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.post;
import static org.springframework.test.web.servlet.result.MockMvcResultHandlers.print;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;
import org.springframework.util.FileSystemUtils;

@SpringBootTest
@AutoConfigureMockMvc(addFilters = false)
public class ArchiveFileControllerTest {

    private static final ObjectMapper MAPPER = new ObjectMapper();

    @MockBean
    private ArchiveService archiveService;

    @Autowired
    private MockMvc mockMvc;

     // TODO: refactor tests
    /*
    @Test
    public void testCreateTarArchive() throws Exception {

        ArchiveRequest request = new ArchiveRequest();
        request.setJobId("123");
        request.setType("TAR");
        request.setPaths(Arrays.asList("/path/to/file1", "/path/to/file2"));

        mockMvc.perform(post("/archive")
                .principal(fakePrincipal("user1"))
                .contentType(MediaType.APPLICATION_JSON)
                .content(MAPPER.writeValueAsString(request)))
                .andDo(print())
                .andExpect(status().is3xxRedirection());

        verify(archiveService, times(1)).createArchive(argThat(job -> {
            assertEquals("123", job.getJobId());
            assertEquals(ArchiveJob.Type.TAR, job.getType());
            assertEquals("user1", job.getPrincipal().getName());
            assertEquals(2, job.getVosPaths().size());
            return true;
        }), any());
    }*/

    @Test
    public void testGetArchive() throws Exception {

        File tmpDir = Files.createTempDirectory("tmp").toFile();

        try {
            tmpDir.toPath().resolve("123.zip").toFile().createNewFile();

            when(archiveService.getArchiveParentDir(any())).thenReturn(tmpDir);

            mockMvc.perform(get("/archive/123.zip")
                    .principal(fakePrincipal("user1")))
                    .andDo(print())
                    .andExpect(status().isOk());

        } finally {
            FileSystemUtils.deleteRecursively(tmpDir);
        }
    }

    /*
    @Test
    public void testAnonymousCantCreateArchive() throws Exception {

        ArchiveRequest request = new ArchiveRequest();
        request.setJobId("123");
        request.setType("ZIP");
        request.setPaths(Arrays.asList("/ignore"));

        mockMvc.perform(post("/archive")
                .principal(fakePrincipal("anonymous"))
                .contentType(MediaType.APPLICATION_JSON)
                .content(MAPPER.writeValueAsString(request)))
                .andDo(print())
                .andExpect(status().isForbidden());
    }*/

    @Test
    public void testAnonymousCantGetArchive() throws Exception {

        mockMvc.perform(get("/archive/123.zip")
                .principal(fakePrincipal("anonymous")))
                .andDo(print())
                .andExpect(status().isForbidden());
    }

    private TokenPrincipal fakePrincipal(String name) {
        TokenPrincipal principal = mock(TokenPrincipal.class);
        when(principal.getName()).thenReturn(name);
        return principal;
    }
}
