package it.inaf.ia2.transfer.persistence;

import it.inaf.ia2.transfer.controller.FileInfo;
import java.util.Optional;
import javax.sql.DataSource;
import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertTrue;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(SpringExtension.class)
@ContextConfiguration(classes = {DataSourceConfig.class})
@TestPropertySource(locations = "classpath:test.properties")
public class FileDAOTest {

    @Autowired
    private DataSource dataSource;

    private FileDAO dao;

    @BeforeEach
    public void init() {
        dao = new FileDAO(dataSource);
    }

    @Test
    public void testGetFileInfo() {

        Optional<FileInfo> optFileInfo = dao.getFileInfo("/test1/file1.txt");

        assertTrue(optFileInfo.isPresent());

        FileInfo fileInfo = optFileInfo.get();

        assertEquals("/home/username1/retrieve/file1.txt", fileInfo.getOsPath());
    }
}
