package it.inaf.ia2.transfer.persistence;

import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(SpringExtension.class)
@ContextConfiguration(classes = {DataSourceConfig.class})
@TestPropertySource(locations = "classpath:test.properties")
public class ListOfFilesDAOTest {

    @Autowired
    private DataSource dataSource;
    private ListOfFilesDAO listOfFilesDao;

    @BeforeEach
    public void init() {
        listOfFilesDao = new ListOfFilesDAO(dataSource);
    }

    @Test
    public void testCreateListOfFiles() {
        List<String> vosPaths = Arrays.asList("/test1/file1.txt", "/test1/file2.txt");
        listOfFilesDao.createList("/test1/.tmp-123.txt", vosPaths);
    }
}
