/*
 * This file is part of vospace-file-service
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.ia2.transfer.persistence.model;

public class JobException extends RuntimeException {

    public static enum Type {

        TRANSIENT("transient"),
        FATAL("fatal");

        private final String value;

        private Type(String v) {
            value = v;
        }

        public String value() {
            return value;
        }
    }

    private final Type type;
    private String errorMessage;
    private String errorDetail;

    public JobException(Type type) {
        this.type = type;
    }

    public Type getType() {
        return type;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public JobException setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    public String getErrorDetail() {
        return errorDetail;
    }

    public JobException setErrorDetail(String errorDetail) {
        this.errorDetail = errorDetail;
        return this;
    }
}
