/*
 * This file is part of vospace-file-service
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.ia2.transfer.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import it.inaf.ia2.transfer.service.ArchiveJob;
import it.inaf.ia2.transfer.service.ArchiveService;
import java.util.Arrays;
import static org.junit.jupiter.api.Assertions.assertEquals;
import org.junit.jupiter.api.Test;
import static org.mockito.ArgumentMatchers.argThat;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.MockMvc;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.post;
import static org.springframework.test.web.servlet.result.MockMvcResultHandlers.print;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

@SpringBootTest
@AutoConfigureMockMvc
public class ArchiveFileControllerTest {

    private static final ObjectMapper MAPPER = new ObjectMapper();

    @MockBean
    private ArchiveService archiveService;

    @Autowired
    private MockMvc mockMvc;

    @Test
    public void testCreateTarArchive() throws Exception {

        ArchiveRequest request = new ArchiveRequest();
        request.setJobId("123");
        request.setType("TAR");
        request.setPaths(Arrays.asList("/path/to/file1", "/path/to/file2"));

        mockMvc.perform(post("/archive")
                .contentType(MediaType.APPLICATION_JSON)
                .content(MAPPER.writeValueAsString(request)))
                .andDo(print())
                .andExpect(status().is3xxRedirection());

        verify(archiveService, times(1)).createArchive(argThat(job -> {
            assertEquals("123", job.getJobId());
            assertEquals(ArchiveJob.Type.TAR, job.getType());
            assertEquals("anonymous", job.getPrincipal().getName());
            assertEquals(2, job.getVosPaths().size());
            return true;
        }));
    }
}
