/*
 * This file is part of vospace-file-service
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.ia2.transfer.persistence;

import it.inaf.ia2.transfer.persistence.model.JobException;
import it.inaf.ia2.transfer.persistence.model.JobException.Type;
import javax.sql.DataSource;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit.jupiter.SpringExtension;
import org.junit.jupiter.api.Test;
import static org.junit.jupiter.api.Assertions.assertTrue;
import static org.junit.jupiter.api.Assertions.assertFalse;
import static org.junit.jupiter.api.Assertions.assertEquals;
import net.ivoa.xml.uws.v1.ExecutionPhase;

@ExtendWith(SpringExtension.class)
@ContextConfiguration(classes = {DataSourceConfig.class})
@TestPropertySource(locations = "classpath:test.properties")
public class JobDAOTest {

    @Autowired
    private DataSource dataSource;

    private JobDAO dao;

    @BeforeEach
    public void init() {
        dao = new JobDAO(dataSource);
    }

    @Test
    public void testJobPhase() {
        assertTrue(dao.isJobExisting("pippo5"));
        assertFalse(dao.isJobExisting("pippo22"));

        ExecutionPhase phase = dao.getJobPhase("pippo5");
        assertEquals(ExecutionPhase.EXECUTING, phase);
        dao.updateJobPhase(ExecutionPhase.COMPLETED, "pippo5");
        phase = dao.getJobPhase("pippo5");
        assertEquals(ExecutionPhase.COMPLETED, phase);
    }

    @Test
    public void testSetJobError() {

        assertEquals(ExecutionPhase.QUEUED, dao.getJobPhase("pippo3"));

        JobException jobError = new JobException(Type.FATAL)
                .setErrorMessage("Error message")
                .setErrorDetail("Error detail");

        dao.setJobError("pippo3", jobError);

        assertEquals(ExecutionPhase.ERROR, dao.getJobPhase("pippo3"));
    }
}
