package it.inaf.ia2.transfer.persistence;

import it.inaf.ia2.transfer.controller.FileInfo;
import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class FileDAO {

    private final JdbcTemplate jdbcTemplate;

    @Autowired
    public FileDAO(DataSource fileCatalogDatasource) {
        this.jdbcTemplate = new JdbcTemplate(fileCatalogDatasource);
    }

    public Optional<FileInfo> getFileInfo(String virtualPath) {

        String sql = "select os_path, is_public, group_read, group_write, owner_id, async_trans from\n"
                + "node n join node_path p on n.node_id = p.node_id\n"
                + "and vos_path = ?";

        FileInfo fileInfo = jdbcTemplate.query(conn -> {
            PreparedStatement ps = conn.prepareStatement(sql);
            ps.setString(1, virtualPath);
            return ps;
        }, rs -> {
            if (rs.next()) {
                FileInfo fi = new FileInfo();
                fi.setOsRelPath(rs.getString("os_path"));
                fi.setIsPublic(rs.getBoolean("is_public"));
                fi.setGroupRead(toList(rs.getArray("group_read")));
                fi.setGroupWrite(toList(rs.getArray("group_write")));
                fi.setOwnerId(rs.getString("owner_id"));
                fi.setAsyncTrans(rs.getBoolean("async_trans"));
                return fi;
            }
            return null;
        });

        return Optional.ofNullable(fileInfo);
    }

    private List<String> toList(Array array) throws SQLException {
        if (array == null) {
            return new ArrayList<>();
        }
        return Arrays.asList((String[]) array.getArray());
    }
}
