package it.inaf.oats.vospace;

import net.ivoa.xml.vospace.v2.Node;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.beans.factory.annotation.Autowired;

import it.inaf.oats.vospace.persistence.NodeDAO;

import net.ivoa.xml.vospace.v2.Property;

import java.util.List;

@RestController
public class CreateNodeController {
    
    @Autowired 
    NodeDAO node_dao;

    @PostMapping(value = "/{path}",
            consumes = {MediaType.APPLICATION_XML_VALUE, MediaType.APPLICATION_JSON_VALUE},
             produces = {MediaType.APPLICATION_XML_VALUE, MediaType.APPLICATION_JSON_VALUE})
    public Node createNode(@PathVariable("path") String path, @RequestBody Node node) {
        
        System.out.println("In createNodeController");
        node_dao.createNode(node);
        return node;
    }
    
    private class RequestWrapper {

    List<Property> nodeProperty;
    String nodeId;
    String nodeType;
    
    
    
    }
    
}
