/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package it.inaf.oats.vospace.persistence;

import net.ivoa.xml.vospace.v2.Node;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Repository;
import org.springframework.http.ResponseEntity;

/**
 *
 * @author bertocco
 */
@Repository
public class NodeDAO {


    private final JdbcTemplate jdbcTemplate;

    @Autowired
    public NodeDAO(DataSource dataSource) {
        jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public Node createNode(Node myNode) {
        
        
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ");
        sb.append("NodeProperty");
        sb.append(" (nodeID,propertyURI,propertyValue) SELECT ?, ?, ?");
        sb.append(" WHERE NOT EXISTS (SELECT * FROM NodeProperty");
        sb.append(" WHERE nodeID=? and propertyURI=?)");
        String sqlQuery = sb.toString();
            
        return myNode;
    }
    
    

    public List<Node> listNode(String nodeIvoId) {

        String sql = "SELECT * FROM Node WHERE ivo_id=?";

        return jdbcTemplate.query(conn -> {
            PreparedStatement ps = conn.prepareStatement(sql);
            ps.setString(1, nodeIvoId);
            return ps;
        }, (row, index) -> {
            Node newNode = new Node();
            newNode.setUri(row.getString("ivo_id"));
            return newNode;
        });

    }

}
