package it.inaf.oats.vospace;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import it.inaf.ia2.aa.TokenFilter;

@SpringBootApplication
public class VospaceApplication {

    public static void main(String[] args) {
        SpringApplication.run(VospaceApplication.class, args);
    }

    @Bean
    public FilterRegistrationBean tokenFilterRegistration() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter(new TokenFilter());
        registration.addUrlPatterns("/*");
        return registration;
    }
}
