package it.inaf.oats.vospace;

import static it.inaf.oats.vospace.VOSpaceXmlTestUtil.loadDocument;
import it.inaf.oats.vospace.persistence.NodeDAO;
import net.ivoa.xml.vospace.v2.ContainerNode;
import net.ivoa.xml.vospace.v2.DataNode;
import net.ivoa.xml.vospace.v2.Node;
import static org.junit.jupiter.api.Assertions.assertEquals;
import org.junit.jupiter.api.Test;
import static org.mockito.ArgumentMatchers.eq;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.MockMvc;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.result.MockMvcResultHandlers.print;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;
import org.w3c.dom.Document;

@SpringBootTest
@AutoConfigureMockMvc
public class ListNodeControllerTest {

    private static final String URI_PREFIX = "vos://example.com!vospace";

    @MockBean
    private NodeDAO dao;

    @Autowired
    private MockMvc mockMvc;

    @Test
    public void testRootXml() throws Exception {

        when(dao.listNode(eq("/"))).thenReturn(getRootNode());

        String xml = mockMvc.perform(get("/nodes")
                .accept(MediaType.APPLICATION_XML))
                .andDo(print())
                .andExpect(status().isOk())
                .andReturn().getResponse().getContentAsString();

        Document doc = loadDocument(xml);
        assertEquals("vos:node", doc.getDocumentElement().getNodeName());
        assertEquals("vos:ContainerNode", doc.getDocumentElement().getAttribute("xsi:type"));

        verify(dao, times(1)).listNode(eq("/"));
    }

    @Test
    public void testNodeXml() throws Exception {

        when(dao.listNode(eq("/mynode"))).thenReturn(getDataNode());

        String xml = mockMvc.perform(get("/nodes/mynode")
                .accept(MediaType.APPLICATION_XML))
                .andDo(print())
                .andExpect(status().isOk())
                .andReturn().getResponse().getContentAsString();

        Document doc = loadDocument(xml);
        assertEquals("vos:node", doc.getDocumentElement().getNodeName());
        assertEquals("vos:DataNode", doc.getDocumentElement().getAttribute("xsi:type"));

        verify(dao, times(1)).listNode(eq("/mynode"));
    }

    private Node getRootNode() {
        ContainerNode root = new ContainerNode();
        root.setUri(URI_PREFIX + "/");
        root.getNodes().add(getDataNode());
        return root;
    }

    private Node getDataNode() {
        DataNode node = new DataNode();
        node.setUri(URI_PREFIX + "/mynode");
        return node;
    }
}
