package it.inaf.oats.vospace;

import java.io.IOException;
import java.io.InputStream;
import java.util.Scanner;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
public class CapabilitiesController {

    @Autowired
    private HttpServletRequest request;

    @GetMapping(value = "/capabilities", produces = {MediaType.APPLICATION_XML_VALUE, MediaType.TEXT_XML_VALUE})
    public String getCapabilities() throws IOException {
        String xml = loadCapabilitiesXmlTemplate();
        return xml.replace("{{ base_url }}", getBaseUrl());
    }

    private String loadCapabilitiesXmlTemplate() throws IOException {
        try ( InputStream in = CapabilitiesController.class.getClassLoader().getResourceAsStream("capabilities.xml")) {
            Scanner s = new Scanner(in).useDelimiter("\\A");
            return s.hasNext() ? s.next() : "";
        }
    }

    /**
     * Generate base URL considering also proxied requests.
     */
    private String getBaseUrl() {

        String forwaredProtocol = request.getHeader("X-Forwarded-Proto");
        String scheme = forwaredProtocol != null ? forwaredProtocol : request.getScheme();

        String forwardedHost = request.getHeader("X-Forwarded-Host");
        if (forwardedHost != null && forwardedHost.contains(",")) {
            // X-Forwarded-Host can be a list of comma separated values
            forwardedHost = forwardedHost.split(",")[0];
        }
        String host = forwardedHost != null ? forwardedHost : request.getServerName();

        UriComponentsBuilder builder = UriComponentsBuilder.newInstance()
                .scheme(scheme).host(host).path(request.getContextPath());

        if (forwardedHost == null) {
            builder.port(request.getServerPort());
        }

        return builder.toUriString();
    }
}
